/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.storage.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.PartialSupport;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.storage.client.StorageEvent;
import com.google.gwt.storage.client.StorageImpl;

@PartialSupport
public final class Storage {
    static final StorageImpl impl = (StorageImpl)GWT.create(StorageImpl.class);
    private static Storage localStorage;
    private static Storage sessionStorage;
    private final String storage;

    public static HandlerRegistration addStorageEventHandler(StorageEvent.Handler handler) {
        return impl.addStorageEventHandler(handler);
    }

    public static Storage getLocalStorageIfSupported() {
        if (localStorage == null && Storage.isLocalStorageSupported()) {
            localStorage = new Storage("localStorage");
        }
        return localStorage;
    }

    public static Storage getSessionStorageIfSupported() {
        if (sessionStorage == null && Storage.isSessionStorageSupported()) {
            sessionStorage = new Storage("sessionStorage");
        }
        return sessionStorage;
    }

    public static boolean isLocalStorageSupported() {
        return StorageSupportDetector.localStorageSupported;
    }

    public static boolean isSessionStorageSupported() {
        return StorageSupportDetector.sessionStorageSupported;
    }

    public static boolean isSupported() {
        return Storage.isLocalStorageSupported() && Storage.isSessionStorageSupported();
    }

    public static void removeStorageEventHandler(StorageEvent.Handler handler) {
        impl.removeStorageEventHandler(handler);
    }

    private Storage(String storage) {
        this.storage = storage;
    }

    public void clear() {
        impl.clear(this.storage);
    }

    public String getItem(String key) {
        return impl.getItem(this.storage, key);
    }

    public int getLength() {
        return impl.getLength(this.storage);
    }

    public String key(int index) {
        return impl.key(this.storage, index);
    }

    public void removeItem(String key) {
        impl.removeItem(this.storage, key);
    }

    public void setItem(String key, String data) {
        assert (key.length() > 0);
        impl.setItem(this.storage, key, data);
    }

    private static class StorageSupportDetector {
        static final boolean localStorageSupported = StorageSupportDetector.checkStorageSupport("localStorage");
        static final boolean sessionStorageSupported = StorageSupportDetector.checkStorageSupport("sessionStorage");

        private StorageSupportDetector() {
        }

        private static native boolean checkStorageSupport(String var0);
    }
}

