/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpBody {
    private StringBuffer body = null;
    public static final String STORAGE_CHARSET = "8859_1";
    public static final String DEFAULT_CHARSET = "8859_1";
    private String charset = "8859_1";
    private boolean isChangedCharset = false;
    private String cacheString = null;
    private static final Pattern patternCharset = Pattern.compile("<META +[^>]+charset *= *['\\x22]?([^>'\\x22;]+)['\\x22]? *>", 2);

    public HttpBody() {
        this.body = new StringBuffer();
        this.cacheString = null;
    }

    public HttpBody(int n) {
        if (n > 0) {
            if (n > 128000) {
                n = 128000;
            }
            this.body = new StringBuffer(n);
        } else {
            this.body = new StringBuffer();
        }
        this.cacheString = null;
    }

    public HttpBody(String string) {
        this();
        if (string == null) {
            return;
        }
        this.setBody(string);
        this.cacheString = null;
    }

    public void setBody(byte[] byArray) {
        this.body = new StringBuffer(byArray.length);
        this.append(byArray);
        this.cacheString = null;
    }

    public void setBody(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes(this.getCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.setBody(byArray);
        this.cacheString = null;
    }

    public void append(byte[] byArray, int n) {
        if (byArray == null) {
            return;
        }
        String string = null;
        try {
            string = new String(byArray, 0, n, "8859_1");
        }
        catch (Exception exception) {
            string = new String(byArray, 0, n);
        }
        this.body.append(string);
        this.cacheString = null;
    }

    public void append(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.append(byArray, byArray.length);
        this.cacheString = null;
    }

    public void append(String string) {
        if (string == null) {
            return;
        }
        this.body.append(string);
        this.cacheString = null;
    }

    public String toString() {
        if (this.cacheString != null) {
            return this.cacheString;
        }
        if (this.isChangedCharset) {
            this.cacheString = this.toString(this.getCharset());
            this.isChangedCharset = false;
            return this.cacheString;
        }
        String string = this.body.toString();
        Matcher matcher = patternCharset.matcher(string);
        if (matcher.find()) {
            this.setCharset(matcher.group(1));
        } else {
            String string2 = this.toUTF8();
            if (string2 != null) {
                this.setCharset("UTF8");
                this.isChangedCharset = false;
                this.cacheString = string2;
                return this.cacheString;
            }
        }
        this.cacheString = this.toString(this.getCharset());
        return this.cacheString;
    }

    public String toString(String string) {
        String string2 = "";
        try {
            string2 = string.equalsIgnoreCase("8859_1") ? this.body.toString() : new String(this.getBytes(), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = this.body.toString();
        }
        return string2;
    }

    public byte[] getBytes() {
        byte[] byArray = null;
        try {
            byArray = this.body.toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return byArray;
    }

    public int length() {
        return this.body.length();
    }

    public void setLength(int n) {
        this.body.setLength(n);
        this.cacheString = null;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.charset = string;
        this.isChangedCharset = true;
    }

    private String toUTF8() {
        byte[] byArray = this.getBytes();
        String string = null;
        byte[] byArray2 = null;
        try {
            string = new String(byArray, "UTF8");
            byArray2 = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("UTF8 not supported.  Using 8859_1 instead.");
            return this.body.toString();
        }
        if (byArray.length != byArray2.length) {
            return null;
        }
        return string;
    }
}

