/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.AttributeHTML;
import org.apache.bcel.util.Class2HTML;
import org.apache.bcel.util.ConstantHTML;

final class MethodHTML
implements Constants {
    private String class_name;
    private PrintWriter file;
    private ConstantHTML constant_html;
    private AttributeHTML attribute_html;

    MethodHTML(String dir, String class_name, Method[] methods, Field[] fields, ConstantHTML constant_html, AttributeHTML attribute_html) throws IOException {
        this.class_name = class_name;
        this.attribute_html = attribute_html;
        this.constant_html = constant_html;
        this.file = new PrintWriter(new FileOutputStream(dir + class_name + "_methods.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
        this.file.println("<TR><TH ALIGN=LEFT>Access&nbsp;flags</TH><TH ALIGN=LEFT>Type</TH><TH ALIGN=LEFT>Field&nbsp;name</TH></TR>");
        int i = 0;
        while (i < fields.length) {
            this.writeField(fields[i]);
            ++i;
        }
        this.file.println("</TABLE>");
        this.file.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Access&nbsp;flags</TH><TH ALIGN=LEFT>Return&nbsp;type</TH><TH ALIGN=LEFT>Method&nbsp;name</TH><TH ALIGN=LEFT>Arguments</TH></TR>");
        int i2 = 0;
        while (i2 < methods.length) {
            this.writeMethod(methods[i2], i2);
            ++i2;
        }
        this.file.println("</TABLE></BODY></HTML>");
        this.file.close();
    }

    private void writeField(Field field) throws IOException {
        String type = Utility.signatureToString(field.getSignature());
        String name = field.getName();
        String access = Utility.accessToString(field.getAccessFlags());
        access = Utility.replace(access, " ", "&nbsp;");
        this.file.print("<TR><TD><FONT COLOR=\"#FF0000\">" + access + "</FONT></TD>\n<TD>" + Class2HTML.referenceType(type) + "</TD><TD><A NAME=\"field" + name + "\">" + name + "</A></TD>");
        Attribute[] attributes = field.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            this.attribute_html.writeAttribute(attributes[i], name + "@" + i);
            ++i;
        }
        int i2 = 0;
        while (i2 < attributes.length) {
            if (attributes[i2].getTag() == 1) {
                String str = ((ConstantValue)attributes[i2]).toString();
                this.file.print("<TD>= <A HREF=\"" + this.class_name + "_attributes.html#" + name + "@" + i2 + "\" TARGET=\"Attributes\">" + str + "</TD>\n");
                break;
            }
            ++i2;
        }
        this.file.println("</TR>");
    }

    private final void writeMethod(Method method, int method_number) throws IOException {
        String signature = method.getSignature();
        String[] args = Utility.methodSignatureArgumentTypes(signature, false);
        String type = Utility.methodSignatureReturnType(signature, false);
        String name = method.getName();
        String access = Utility.accessToString(method.getAccessFlags());
        Attribute[] attributes = method.getAttributes();
        access = Utility.replace(access, " ", "&nbsp;");
        String html_name = Class2HTML.toHTML(name);
        this.file.print("<TR VALIGN=TOP><TD><FONT COLOR=\"#FF0000\"><A NAME=method" + method_number + ">" + access + "</A></FONT></TD>");
        this.file.print("<TD>" + Class2HTML.referenceType(type) + "</TD><TD>" + "<A HREF=" + this.class_name + "_code.html#method" + method_number + " TARGET=Code>" + html_name + "</A></TD>\n<TD>(");
        int i = 0;
        while (i < args.length) {
            this.file.print(Class2HTML.referenceType(args[i]));
            if (i < args.length - 1) {
                this.file.print(", ");
            }
            ++i;
        }
        this.file.print(")</TD></TR>");
        int i2 = 0;
        while (i2 < attributes.length) {
            int j;
            this.attribute_html.writeAttribute(attributes[i2], "method" + method_number + "@" + i2, method_number);
            byte tag = attributes[i2].getTag();
            if (tag == 3) {
                this.file.print("<TR VALIGN=TOP><TD COLSPAN=2></TD><TH ALIGN=LEFT>throws</TH><TD>");
                int[] exceptions = ((ExceptionTable)attributes[i2]).getExceptionIndexTable();
                j = 0;
                while (j < exceptions.length) {
                    this.file.print(this.constant_html.referenceConstant(exceptions[j]));
                    if (j < exceptions.length - 1) {
                        this.file.print(", ");
                    }
                    ++j;
                }
                this.file.println("</TD></TR>");
            } else if (tag == 2) {
                Attribute[] c_a = ((Code)attributes[i2]).getAttributes();
                j = 0;
                while (j < c_a.length) {
                    this.attribute_html.writeAttribute(c_a[j], "method" + method_number + "@" + i2 + "@" + j, method_number);
                    ++j;
                }
            }
            ++i2;
        }
    }
}

