/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results;

import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.VisitedGraphResults;
import org.gradle.api.internal.artifacts.result.MinimalResolutionResult;

public class DefaultVisitedGraphResults
implements VisitedGraphResults {
    private final MinimalResolutionResult resolutionResult;
    private final Set<UnresolvedDependency> unresolvedDependencies;
    private final ResolveException resolutionFailure;

    public DefaultVisitedGraphResults(MinimalResolutionResult resolutionResult, Set<UnresolvedDependency> unresolvedDependencies, @Nullable ResolveException resolutionFailure) {
        this.resolutionResult = resolutionResult;
        this.unresolvedDependencies = unresolvedDependencies;
        this.resolutionFailure = resolutionFailure;
    }

    @Override
    public boolean hasAnyFailure() {
        return !this.unresolvedDependencies.isEmpty() || this.resolutionFailure != null;
    }

    @Override
    public void visitFailures(Consumer<Throwable> visitor) {
        for (UnresolvedDependency unresolvedDependency : this.unresolvedDependencies) {
            visitor.accept(unresolvedDependency.getProblem());
        }
        if (this.resolutionFailure != null) {
            visitor.accept((Throwable)this.resolutionFailure);
        }
    }

    @Override
    public MinimalResolutionResult getResolutionResult() {
        return this.resolutionResult;
    }

    @Override
    public Set<UnresolvedDependency> getUnresolvedDependencies() {
        return this.unresolvedDependencies;
    }

    @Override
    public Optional<ResolveException> getResolutionFailure() {
        return Optional.ofNullable(this.resolutionFailure);
    }
}

