.\"$Header: /home/vikas/netmgt/nocol/src/doc/RCS/pingmon.8,v 1.5 1994/11/29 20:12:56 vikas Exp $
.\"
.TH PINGMON 8 "May 1994"
.SH NAME
pingmon \- NOCOL reachability monitor for hosts and network devices (
.BR ip pingmon,
.BR rpc pingmon
& 
.BR osi pingmon)
.SH SYNOPSIS
.B ippingmon
[
.B \-d
] [
.B \-o
.I <output-data-file>
] [
.B \-p
.I <ping command>
] [
.I config-file
]
.br
.BI rpcpingmon ...
.\"
.SH DESCRIPTION
.LP
.BR ippingmon ,
.BR rpcpingmon ,
.B osipingmon
are NOCOL monitors for testing reachability of remote hosts and network
devices.
.I ippingmon 
and 
.I osipingmon
monitor reachability using ICMP echo requests, and
.I rpcpingmon
tests the status of the portmapper on remote hosts.
.LP
The ICMP monitors use the standard
.I ping
program to send 10 ICMP packets to the list of hosts specified in the 
configuration file and if the number of lost packets exceeds a certain
threshold (set to 3 packets by default), the site is marked as DOWN and
the NOCOL severity of the site is escalated. The severity is escalated in
each pass if the site is still unreachable (till it reaches the maximum
severity of CRITICAL).
This gradual escalation of severity avoids false alarms since when a site is
CRITICAL, it has been ping-ed and marked unreachable atleast 3 times.
.LP
In the case of
.IR rpcping ,
a host is marked as down if the portmapper does not respond within a timeout
interval (set to 20 secs by default in the
.I rpcping
program). Escalation of severity is similar to the method described for
ippingmon above.
.LP
The programs do a 
.IR popen (3)
call to the respective ping programs and parse the output to determine the
status of the site. Two support programs are provided \-
.I multiping
and
.I rpcping
for use with the pingmon monitors.
The
.I osiping
program is available with OSI protocol software and usually produces output
similar to the IP ping program.
.LP
The
.BR multiping (8)
program is very useful to test a large number of sites via IP ICMP since
it can take a large amount of time in each pass before a site is tested
again.
It is advisable to use this program instead of the standard Unix ping program.
No such program is available (at this time) for OSI networks.
.\"
.SH OPTIONS
.TP 5
.B \-d
prints debugging output.
.TP 3
.BI \-o " <output-data-file>"
The name of the nocol format datafile produced by ippingmon. By default,
this file is 
.I ETCDIR/ippingmon-output.
.TP 3
.BI \-p  " <ping-program>"
This is the path to the 
.I ping
program to be used for sending ICMP packets to the remote hosts.
This must produce output summary lines in the format:
.RS
.sp
.nf
   navya%  ping -s  abc.foo.com 100 10 | tail -2
    5 packets transmitted, 5 packets received, 0% packet loss
    round-trip (ms)  min/avg/max = 4/5/7
.fi
.sp
.RE
Set the default location of the ping program during compile time (or
if you are using
.I multiping
instead).
.TP 3
.I <config-file>
This is the list of nodes to monitor (config file). By default, the files
are expected to be in the ETCDIR and have the name
.B ippingmon-confg
or
.B rpcpingmon-confg
or
.B osipingmon-confg
(depending on the monitor being used\- IP ping, OSI ping or RPC ping).
The format of this file is:
.RS
.sp
.nf
  POLLINTERVAL   <secs>
  sitename  address
  sitename  address
  sitename  address  TEST
.fi
.RE
.sp
The
.I TEST
keyword sets the NOCOP
.I test
option in the EVENT structure. This is useful to mark sites that are
NOT in production yet and need to be monitored. The post-processors
can then differentiate between test sites and production sites.
.SH CAVEATS
The program relies on external ping programs and expects to parse ping output
in a pre-determined format.
.\"------------------------------------
.SH AUTHOR
Vikas Aggarwal, vikas@navya.com.
.SH SEE ALSO
netconsole(1) nocol-prog(3) perlnocol(3)
etherload(8) eventselect(8) genmon(8) noclogd(8) nocol-overview(8)
nocol-utility(8) nsmon(8) pingmon(8) portmon(8) 
tpmon(8) trapmon(8)

