<?php
/**
 * phpDocumentor
 *
 * PHP Version 5
 *
 * @package   phpDocumentor\GraphViz\Tests
 * @author    Danny van der Sluijs <danny.vandersluijs@fleppuhstein.com>
 * @copyright 2012 Danny van der Sluijs (http://www.fleppuhstein.com)
 * @license   http://www.opensource.org/licenses/mit-license.php MIT
 * @link      http://phpDocumentor-project.org
 */
namespace phpDocumentor\GraphViz;

use phpDocumentor\GraphViz\Graph;
use phpDocumentor\GraphViz\Node;

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.0 on 2012-12-09 at 19:06:57.
 */
class GraphTest extends \PHPUnit_Framework_TestCase {

    /**
     * @var Graph
     */
    protected $fixture;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->fixture = new Graph;
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {

    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::create
     */
    public function testCreate()
    {
        $fixture = Graph::create();
        $this->assertInstanceOf(
            'phpDocumentor\GraphViz\Graph',
            $fixture
        );
        $this->assertSame(
            'G',
            $fixture->getName()
        );
        $this->assertSame(
            'digraph',
            $fixture->getType()
        );

        $fixture = Graph::create('MyName', false);
        $this->assertSame(
            'MyName',
            $fixture->getName()
        );
        $this->assertSame(
            'graph',
            $fixture->getType()
        );
    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::setName
     */
    public function testSetName()
    {
        $this->assertSame(
            $this->fixture, $this->fixture->setName('otherName'),
            'Expecting a fluent interface'
        );
    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::getName
     */
    public function testGetName()
    {
        $this->assertSame(
            $this->fixture->getName(), 'G',
            'Expecting the name to match the initial state'
        );
        $this->fixture->setName('otherName');
        $this->assertSame(
            $this->fixture->getName(), 'otherName',
            'Expecting the name to contain the new value'
        );
    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::setType
     */
    public function testSetType()
    {
        $this->assertSame(
            $this->fixture, $this->fixture->setType('digraph'),
            'Expecting a fluent interface'
        );
        $this->assertSame(
            $this->fixture, $this->fixture->setType('graph'),
            'Expecting a fluent interface'
        );
        $this->assertSame(
            $this->fixture, $this->fixture->setType('subgraph'),
            'Expecting a fluent interface'
        );
    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::setType
     */
    public function testSetTypeException()
    {
        $this->setExpectedException('\InvalidArgumentException');
        $this->fixture->setType('fakegraphg');
    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::getType
     */
    public function testGetType()
    {
        $this->assertSame(
            $this->fixture->getType(),
            'digraph'
        );
        $this->fixture->setType('graph');
        $this->assertSame(
            $this->fixture->getType(),
            'graph'
        );
    }

    public function testSetStrict()
    {
        $this->assertSame(
            $this->fixture, $this->fixture->setStrict(true),
            'Expecting a fluent interface'
        );
        $this->assertSame(
            $this->fixture, $this->fixture->setStrict(false),
            'Expecting a fluent interface'
        );
    }

    public function testIsStrict()
    {
        $this->assertSame(
            $this->fixture->isStrict(),
            false
        );
        $this->fixture->setStrict(true);
        $this->assertSame(
            $this->fixture->isStrict(),
            true
        );
    }

    public function testSetPath()
    {
        $this->assertSame(
            $this->fixture, $this->fixture->setPath(__DIR__),
            'Expecting a fluent interface'
        );
    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::__call
     */
    public function test__call()
    {
        $this->assertNull($this->fixture->MyMethod());
        $this->assertSame($this->fixture, $this->fixture->setColor('black'));
        $this->assertSame('black', $this->fixture->getColor()->getValue());
    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::addGraph
     */
    public function testAddGraph()
    {
        $this->assertSame(
            $this->fixture,
            $this->fixture->addGraph($this->getMock('phpDocumentor\GraphViz\Graph'))
        );
    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::hasGraph
     */
    public function testHasGraph()
    {
        $mock = $this->getMock('phpDocumentor\GraphViz\Graph');
        $mock->expects($this->any())->method('getName')->will($this->returnValue('MyName'));
        $this->assertFalse($this->fixture->hasGraph('MyName'));
        $this->fixture->addGraph($mock);
        $this->assertTrue($this->fixture->hasGraph('MyName'));
    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::getGraph
     */
    public function testGetGraph()
    {
        $mock = $this->getMock('phpDocumentor\GraphViz\Graph');
        $mock->expects($this->any())->method('getName')->will($this->returnValue('MyName'));

        $this->fixture->addGraph($mock);
        $this->assertSame(
            $mock,
            $this->fixture->getGraph('MyName')
        );
    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::setNode
     */
    public function testSetNode()
    {
        $mock = $this->getMock('phpDocumentor\GraphViz\Node', array(), array(), '', false);
        $mock->expects($this->any())->method('getName')->will($this->returnValue('MyName'));

        $this->assertSame(
            $this->fixture,
            $this->fixture->setNode($mock)
        );
    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::findNode
     */
    public function testFindNode() {
        $this->assertNull($this->fixture->findNode('MyNode'));

        $mock = $this->getMock('phpDocumentor\GraphViz\Node', array(), array(), '', false);
        $mock->expects($this->any())->method('getName')->will($this->returnValue('MyName'));
        $this->fixture->setNode($mock);
        $this->assertSame(
            $mock,
            $this->fixture->findNode('MyName')
        );

        $subGraph = Graph::create();
        $mock2 = $this->getMock('phpDocumentor\GraphViz\Node', array(), array(), '', false);
        $mock2->expects($this->any())->method('getName')->will($this->returnValue('MyName2'));
        $subGraph->setNode($mock2);

        $this->fixture->addGraph($subGraph);
        $this->assertSame(
            $mock2,
            $this->fixture->findNode('MyName2')
        );

    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::__set
     * @todo   Implement test__set().
     */
    public function test__set() {
        $mock = $this->getMock('phpDocumentor\GraphViz\Node', array(), array(), '', false);
        $mock->expects($this->any())->method('getName')->will($this->returnValue('MyName'));

        $this->assertSame(
            $this->fixture,
            $this->fixture->__set('myNode', $mock)
        );
    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::__get
     * @todo   Implement test__get().
     */
    public function test__get() {
        $mock = $this->getMock('phpDocumentor\GraphViz\Node', array(), array(), '', false);
        $mock->expects($this->any())->method('getName')->will($this->returnValue('MyName'));

        $this->fixture->myNode = $mock;
        $this->assertSame(
            $mock,
            $this->fixture->myNode
        );
    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::link
     * @todo   Implement testLink().
     */
    public function testLink() {
        $mock = $this->getMock('phpDocumentor\GraphViz\Edge', array(), array(), '', false);

        $this->assertSame(
            $this->fixture,
            $this->fixture->link($mock)
        );
    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::export
     */
    public function testExportException() {
        $graph = Graph::create('My First Graph');
        $filename = tempnam(sys_get_temp_dir(), 'tst');

        $this->setExpectedException('phpDocumentor\GraphViz\Exception');
        $graph->export('fpd', $filename);

    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::export
     */
    public function testExport() {
        $graph = Graph::create('My First Graph');
        $filename = tempnam(sys_get_temp_dir(), 'tst');

        $this->assertSame(
            $graph,
            $graph->export('pdf', $filename)
        );
        $this->assertTrue(is_readable($filename));
    }

    /**
     * @covers phpDocumentor\GraphViz\Graph::__toString
     */
    public function test__toString()
    {
        $graph = Graph::create('My First Graph');
        $this->assertSame(
            (string) $graph,
            ('digraph "My First Graph" {' . PHP_EOL . PHP_EOL . '}')
        );

        $graph->setLabel('PigeonPost');
        $this->assertSame(
            (string) $graph,
            ('digraph "My First Graph" {' . PHP_EOL . 'label="PigeonPost"' . PHP_EOL . '}')
        );

        $graph->setStrict(true);
        $this->assertSame(
            (string) $graph,
            ('strict digraph "My First Graph" {' . PHP_EOL . 'label="PigeonPost"' . PHP_EOL . '}')
        );
    }

}
