/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.Timer;

public class AutoRepeatButtonUtils
implements ActionListener,
MouseListener {
    public static String AUTO_REPEAT = "AutoRepeat";
    public static String CLIENT_PROPERTY_AUTO_REPEAT = "AutoRepeat.AutoRepeatButtonUtils";
    public static int DEFAULT_DELAY = 200;
    public static int DEFAULT_INITIAL_DELAY = 500;
    private Timer _timer = null;
    private AbstractButton _button;

    public static void install(AbstractButton button) {
        AutoRepeatButtonUtils.uninstall(button);
        new AutoRepeatButtonUtils().installListeners(button, DEFAULT_DELAY, DEFAULT_INITIAL_DELAY);
    }

    public static void install(AbstractButton button, int delay, int initialDelay) {
        AutoRepeatButtonUtils.uninstall(button);
        new AutoRepeatButtonUtils().installListeners(button, delay, initialDelay);
    }

    public static void uninstall(AbstractButton button) {
        Object clientProperty = button.getClientProperty(CLIENT_PROPERTY_AUTO_REPEAT);
        if (clientProperty instanceof AutoRepeatButtonUtils) {
            ((AutoRepeatButtonUtils)clientProperty).uninstallListeners();
        }
    }

    protected void installListeners(AbstractButton button, int delay, int initialDelay) {
        this._button = button;
        button.putClientProperty(CLIENT_PROPERTY_AUTO_REPEAT, this);
        button.addMouseListener(this);
        this._timer = new Timer(delay, this);
        this._timer.setInitialDelay(initialDelay);
        this._timer.setRepeats(true);
    }

    protected void uninstallListeners() {
        if (this._button != null) {
            this._button.putClientProperty(CLIENT_PROPERTY_AUTO_REPEAT, null);
            this._button.removeMouseListener(this);
            this._button = null;
        }
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    public void mousePressed(MouseEvent e) {
        this._timer.start();
    }

    public void mouseReleased(MouseEvent e) {
        this._timer.stop();
    }

    public void mouseExited(MouseEvent e) {
        this._timer.stop();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent event) {
        if (!this._button.getModel().isPressed()) {
            return;
        }
        ActionListener[] listeners = this._button.getActionListeners();
        ActionEvent e = null;
        for (int i = listeners.length - 1; i >= 0; --i) {
            ActionListener listener = listeners[i];
            if (e == null) {
                String actionCommand = event.getActionCommand();
                if (actionCommand == null) {
                    actionCommand = this._button.getActionCommand();
                }
                e = new ActionEvent(this._button, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            listener.actionPerformed(e);
        }
    }
}

