package TDS::Replacer;
# $Id: Replacer.pm,v 1.2 2000/12/20 14:59:36 tom Exp $
################################################################

use strict;
use vars qw(@ISA);

use ClassObject;

@ISA = qw(ClassObject);

################################################################

sub new
{
    my $class = shift;

##    warn times, "replacer inited";
    
    require TDS::Replacer::Url;
    require TDS::Replacer::Term;
    require TDS::Replacer::Dictionary;

    # url, term
    my $self = {'url'=>new TDS::Replacer::Url,
		'term'=>new TDS::Replacer::Term};
    $self->{'url'}->Read;
    $self->{'term'}->Read;

    # dic
    $self->{'dic'} = new TDS::Replacer::Dictionary(replacer_url=>$self->{'url'});
    $self->{'dic'}->Read;

    # bless
    bless $self, $class;

    $self->{'dic'}->Read;

##    warn times, "replacer inited done.";
    return $self;
}

sub ReplaceLine($\$)
{
    my ($self, $line) = self_or_default(@_);

    $self->{'dic'}->ReplaceLine($line);
    $self->{'url'}->ReplaceLine($line);
    $self->{'term'}->ReplaceLine($line);
    return $line;
}

1;
