/*
 * Decompiled with CFR 0.152.
 */
package com.gokgs.client.swing;

import com.gokgs.client.KCChallenge;
import com.gokgs.client.KCGame;
import com.gokgs.client.KCProposal;
import com.gokgs.shared.KGameType;
import com.gokgs.shared.KRole;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.igoweb.igoweb.client.CGameListEntry;
import org.igoweb.igoweb.client.CRoom;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.UserRenderer;
import org.igoweb.igoweb.shared.IBundle;
import org.igoweb.igoweb.shared.Role;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.AList;
import org.igoweb.util.swing.GuiUtil;
import org.igoweb.util.xml.HtmlUtil;

public class KGameRenderer
extends JComponent
implements ListCellRenderer<CGameListEntry> {
    private final Font stdFont = UIManager.getFont("Label.font");
    private final Font boldFont = this.stdFont.deriveFont(1);
    private CGameListEntry currentGame = null;
    private boolean isRengo;
    private final Client client;
    private final boolean showRoomName;
    private final int fontH = UIManager.getInt("org.igoweb.fontH");

    public KGameRenderer(Client client, boolean showRoomName) {
        this.client = client;
        this.showRoomName = showRoomName;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends CGameListEntry> list, CGameListEntry game, int index, boolean isSelected, boolean cellHasFocus) {
        this.currentGame = game;
        this.isRengo = this.currentGame != null && this.currentGame.gameType == KGameType.RENGO;
        this.setBackground(UIManager.getColor(((AList.InnerList)list).mouseUnder() == this.currentGame ? "org.igoweb.selTextBg" : "org.igoweb.inputBg"));
        if (this.currentGame == null) {
            this.setToolTipText(null);
            return this;
        }
        this.setToolTipText(HtmlUtil.textToHtml(this.currentGame.gameType == KGameType.CHALLENGE ? this.buildChalToolTip((KCChallenge)this.currentGame) : this.buildGameToolTip((KCGame)this.currentGame), false, true));
        return this;
    }

    private String buildChalToolTip(KCChallenge chal) {
        StringBuilder toolTip = new StringBuilder();
        String notes = chal.getName();
        if (notes != null && notes.length() > 0) {
            toolTip.append(notes).append('\n');
        }
        if (((KCProposal)chal.getInitialProposal()).isPrivate()) {
            toolTip.append(Defs.getString(-903340529)).append('\n');
        }
        return toolTip.append(((KCProposal)chal.getInitialProposal()).getRules().getTimeDescription()).toString();
    }

    private String buildGameToolTip(KCGame game) {
        CRoom room;
        StringBuilder toolTip = new StringBuilder();
        if (game.getName() != null && game.getName().length() != 0) {
            toolTip.append(game.getName()).append('\n');
        }
        toolTip.append(Defs.getString(-1388380729 + game.gameType.id));
        if (game.isSubscribersOnly()) {
            toolTip.append('\n').append(Defs.getString(-903340481));
        }
        if (game.isPrivate()) {
            toolTip.append('\n').append(Defs.getString(-903340529));
        }
        if (game.isEvent()) {
            toolTip.append('\n').append(Defs.getString(-903340480));
        }
        if (this.showRoomName && (room = this.client.getRoom(game)) != null) {
            toolTip.append('\n').append(room.getName());
        }
        return toolTip.toString();
    }

    @Override
    public void paint(Graphics g) {
        if (this.currentGame == null) {
            return;
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.currentGame instanceof KCChallenge) {
            this.paintChal(g, (KCChallenge)this.currentGame);
        } else {
            this.paintGame(g, (KCGame)this.currentGame);
        }
    }

    private void paintChal(Graphics g, KCChallenge chal) {
        g.setColor(UIManager.getColor("Label.foreground"));
        int x = 2;
        int y = g.getFontMetrics().getAscent();
        int userW = UserRenderer.getMinimumWidth(false);
        KCProposal prop = (KCProposal)chal.getInitialProposal();
        String type = Defs.getString(prop.isPrivate() ? 2031923687 : -266865813 + prop.getGameType().id);
        g.setFont(this.boldFont);
        if (this.showRoomName) {
            userW = userW * 2 / 3;
            CRoom room = this.client.getRoom(chal);
            if (room != null) {
                g.drawString(GuiUtil.makeStringFit(room.getName(), g, this.fontH * 8), x, y);
            }
            x += this.fontH * 8;
        }
        String ownerText = chal.getPlayer(KRole.CHALLENGE_CREATOR).getNameAndRank();
        if (chal.getPlayer(KRole.CHALLENGE_CREATOR).isRobot()) {
            ownerText = Defs.getString(-903340512, ownerText);
        }
        g.drawString(type, x, y);
        g.drawString(ownerText, x += this.fontH, y);
        x += userW + userW;
        Object[] szArgs = new Object[]{new Integer(prop.getRules().getSize()), new Integer(0)};
        if (chal.getName() == null || chal.getName().length() == 0) {
            g.drawString(Defs.getString(-669080762, szArgs), x, y);
        } else {
            szArgs[1] = chal.getName();
            g.drawString(Defs.getString(-903340666, szArgs), x, y);
        }
    }

    private void paintGame(Graphics g, KCGame game) {
        String white;
        String black;
        int y;
        g.setColor(game.isAdjourned() ? UIManager.getColor("org.igoweb.stdBg").darker() : UIManager.getColor("Label.foreground"));
        int x = 2;
        int y2 = y = g.getFontMetrics().getAscent();
        if (this.isRengo) {
            y2 += this.fontH / 2;
        }
        int userW = UserRenderer.getMinimumWidth(false);
        String type = Defs.getString(game.isSubscribersOnly() ? 2031923688 : (game.isPrivate() ? 2031923687 : -266865813 + game.gameType.id));
        g.setFont(this.stdFont);
        if (this.showRoomName) {
            CRoom room = this.client.getRoom(game);
            if (room != null) {
                g.drawString(GuiUtil.makeStringFit(room.getName(), g, this.fontH * 8), x, y);
            }
            x += this.fontH * 8;
        }
        IBundle bundle = IBundle.get();
        if (game.gameType == KGameType.DEMONSTRATION) {
            black = null;
            white = game.getPlayer(KRole.OWNER).getNameAndRank(bundle);
        } else if (game.gameType == KGameType.REVIEW) {
            black = null;
            white = GuiUtil.makeStringFit(Defs.getString(-669080763, new Object[]{game.getPlayer(KRole.OWNER).getNameAndRank(bundle), game.getPlayer((Role)KRole.WHITE).name, game.getPlayer((Role)KRole.BLACK).name}), g, 2 * userW);
        } else if (game.gameType == KGameType.RENGO_REVIEW) {
            black = null;
            white = GuiUtil.makeStringFit(Defs.getString(696435397, new Object[]{game.getPlayer(KRole.OWNER).getNameAndRank(bundle), game.getPlayer(KRole.WHITE).getNameAndRank(bundle), game.getPlayer(KRole.WHITE_2).getNameAndRank(bundle), game.getPlayer(KRole.BLACK).getNameAndRank(bundle), game.getPlayer(KRole.BLACK_2).getNameAndRank(bundle)}), g, userW * 2);
        } else {
            white = game.getPlayer(KRole.WHITE).getNameAndRank(bundle);
            black = game.getPlayer(KRole.BLACK).getNameAndRank(bundle);
        }
        g.drawString(type, x, y2);
        g.drawString(white, x += this.fontH, y);
        if (this.isRengo) {
            g.drawString(game.getPlayer(KRole.WHITE_2).getNameAndRank(bundle), x, y + this.fontH);
        }
        x += userW;
        if (black != null) {
            g.drawString(black, x, y);
        }
        if (this.isRengo) {
            g.drawString(game.getPlayer(KRole.BLACK_2).getNameAndRank(bundle), x, y + this.fontH);
        }
        Object[] szArgs = new Object[]{new Integer(game.getRules().getSize()), new Integer(game.getRules().getHandicap())};
        g.drawString(Defs.getString(-669080762, szArgs), x += userW, y2);
        x += 11 * this.fontH / 2;
        if (game.isOver()) {
            g.drawString(game.gameType.isMainRole(KRole.WHITE) ? bundle.formatScore(game.getScore()) : "-", x, y2);
        } else if (game.getMoveNum() > 0) {
            g.drawString(Defs.getString(2031923690, game.getMoveNum()), x, y2);
        }
        g.drawString(Defs.getString(-903340665, game.getNumObservers()), x += 5 * this.fontH, y2);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(2 + this.fontH * 18, this.isRengo ? this.fontH * 2 : this.fontH);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

