/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.demos.raw.adapter;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import javax.swing.JFrame;
import org.flexdock.demos.util.DemoUtility;
import org.flexdock.demos.util.Titlepane;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.defaults.DefaultDockingPort;

public class AdapterDemo
extends JFrame {
    private DefaultDockingPort port;

    public static void main(String[] args) {
        System.setProperty("flexdock.adapters", "org/flexdock/demos/raw/adapter/docking-adapter.xml");
        DockingManager.setFloatingEnabled(true);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                AdapterDemo.createAndShowGui();
            }
        });
    }

    private static void createAndShowGui() {
        AdapterDemo frame = new AdapterDemo();
        frame.setSize(500, 500);
        DemoUtility.setCloseOperation(frame);
        frame.setVisible(true);
    }

    public AdapterDemo() {
        super("Adapter Demo");
        this.setContentPane(this.createContentPane());
    }

    private Container createContentPane() {
        this.port = new DefaultDockingPort();
        Titlepane pane1 = new Titlepane("View 1");
        Titlepane pane2 = new Titlepane("View 2");
        Titlepane pane3 = new Titlepane("View 3");
        Titlepane pane4 = new Titlepane("View 4");
        Titlepane pane5 = new Titlepane("View 5");
        DockingManager.dock((Component)pane1, this.port);
        DockingManager.dock(pane2, pane1, "NORTH", 0.3f);
        DockingManager.dock((Component)pane3, pane1, "SOUTH");
        DockingManager.dock(pane4, pane1, "EAST", 0.3f);
        DockingManager.dock((Component)pane5, pane1, "WEST");
        return this.port;
    }
}

