/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia.util;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.WeakHashMap;
import net.sourceforge.mlf.metouia.util.Gradient;
import net.sourceforge.mlf.metouia.util.GradientInfo;

public class FastGradientPaintContext
implements PaintContext {
    private static WeakHashMap gradientCache = new WeakHashMap();
    private static LinkedList recentInfos = new LinkedList();
    private GradientInfo info = new GradientInfo();
    private int parallelDevicePos;
    private Gradient gradient;

    public void dispose() {
        this.gradient.dispose();
    }

    public ColorModel getColorModel() {
        return this.info.model;
    }

    public synchronized Raster getRaster(int n, int n2, int n3, int n4) {
        if (this.info.isVertical) {
            return this.gradient.getRaster(n2 - this.parallelDevicePos, n3, n4);
        }
        return this.gradient.getRaster(n - this.parallelDevicePos, n4, n3);
    }

    public FastGradientPaintContext(ColorModel colorModel, Rectangle rectangle, int n, int n2, boolean bl, boolean bl2) {
        Object object;
        this.info.isAscending = bl2;
        this.info.model = ((n & n2) >> 24 & 0xFF) != 255 ? ColorModel.getRGBdefault() : colorModel;
        this.info.startColor = n;
        this.info.endColor = n2;
        this.info.isVertical = bl;
        if (this.info.isVertical) {
            this.parallelDevicePos = rectangle.y;
            this.info.parallelLength = rectangle.height;
        } else {
            this.parallelDevicePos = rectangle.x;
            this.info.parallelLength = rectangle.width;
        }
        recentInfos.remove(this.info);
        recentInfos.add(0, this.info);
        if (recentInfos.size() > 16) {
            recentInfos.removeLast();
        }
        if ((object = gradientCache.get(this.info)) != null) {
            object = ((WeakReference)object).get();
        }
        if (object != null) {
            this.gradient = (Gradient)object;
        } else {
            this.gradient = new Gradient(this.info);
            gradientCache.put(this.info, new WeakReference<Gradient>(this.gradient));
        }
    }
}

