/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.classpath.SystemProperties;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LocaleData;
import java.util.MissingResourceException;
import java.util.PropertyPermission;
import java.util.ResourceBundle;

public final class Locale
implements Serializable,
Cloneable {
    public static final Locale ENGLISH = Locale.getLocale("en");
    public static final Locale FRENCH = Locale.getLocale("fr");
    public static final Locale GERMAN = Locale.getLocale("de");
    public static final Locale ITALIAN = Locale.getLocale("it");
    public static final Locale JAPANESE = Locale.getLocale("ja");
    public static final Locale KOREAN = Locale.getLocale("ko");
    public static final Locale CHINESE = Locale.getLocale("zh");
    public static final Locale SIMPLIFIED_CHINESE = Locale.getLocale("zh", "CN");
    public static final Locale TRADITIONAL_CHINESE = Locale.getLocale("zh", "TW");
    public static final Locale FRANCE = Locale.getLocale("fr", "FR");
    public static final Locale GERMANY = Locale.getLocale("de", "DE");
    public static final Locale ITALY = Locale.getLocale("it", "IT");
    public static final Locale JAPAN = Locale.getLocale("ja", "JP");
    public static final Locale KOREA = Locale.getLocale("ko", "KR");
    public static final Locale CHINA;
    public static final Locale PRC;
    public static final Locale TAIWAN;
    public static final Locale UK;
    public static final Locale US;
    public static final Locale CANADA;
    public static final Locale CANADA_FRENCH;
    private static final long serialVersionUID = 9149081749638150636L;
    private static transient Locale[] availableLocales;
    private static transient HashMap localeMap;
    private static Locale defaultLocale;
    private static transient String[] languageCache;
    private static transient String[] countryCache;
    private String language;
    private String country;
    private String variant;
    private transient int hashcode;

    private static final Locale getLocale(String string) {
        return Locale.getLocale(string, "", "");
    }

    private static final Locale getLocale(String string, String string2) {
        return Locale.getLocale(string, string2, "");
    }

    private static final Locale getLocale(String string, String string2, String string3) {
        String string4;
        Locale locale;
        if (localeMap == null) {
            localeMap = new HashMap(256);
        }
        if ((locale = (Locale)localeMap.get(string4 = string + '_' + string2 + '_' + string3)) == null) {
            locale = new Locale(string, string2, string3);
            localeMap.put(string4, locale);
        }
        return locale;
    }

    private final String convertLanguage(String string) {
        if (string.equals("")) {
            return string;
        }
        int n = "he,id,yi".indexOf(string = string.toLowerCase());
        if (n != -1) {
            return "iw,in,ji".substring(n, n + 2);
        }
        return string;
    }

    public static final Locale getDefault() {
        return defaultLocale;
    }

    public static final void setDefault(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission("user.language", "write"));
        }
        defaultLocale = locale;
    }

    public static final synchronized Locale[] getAvailableLocales() {
        if (availableLocales == null) {
            String[] stringArray = LocaleData.localeNames;
            availableLocales = new Locale[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                int n2;
                String string = "";
                String string2 = "";
                String string3 = stringArray[n];
                String string4 = string3.substring(0, 2);
                if (string3.length() > 2) {
                    string = string3.substring(3);
                }
                if ((n2 = string.indexOf("_")) > 0) {
                    string2 = string.substring(n2 + 1);
                    string = string.substring(0, n2 - 1);
                }
                Locale.availableLocales[n] = Locale.getLocale(string4, string, string2);
                ++n;
            }
        }
        return availableLocales;
    }

    public static final String[] getISOCountries() {
        if (countryCache == null) {
            countryCache = Locale.getISOStrings("territories");
        }
        return countryCache;
    }

    public static final String[] getISOLanguages() {
        if (languageCache == null) {
            languageCache = Locale.getISOStrings("languages");
        }
        return languageCache;
    }

    private static final String[] getISOStrings(String string) {
        Object object;
        int n = 0;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation");
        Enumeration enumeration = resourceBundle.getKeys();
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            String string2;
            object = (String)enumeration.nextElement();
            if (!object.startsWith(string + '.') || (string2 = object.substring(string.length() + 1)).length() != 2 || !Character.isLetter(string2.charAt(0)) || !Character.isLetter(string2.charAt(1))) continue;
            arrayList.add(string2);
            ++n;
        }
        object = new String[n];
        int n2 = 0;
        while (n2 < n) {
            object[n2] = (String)arrayList.get(n2);
            ++n2;
        }
        return object;
    }

    public final String getLanguage() {
        return this.language;
    }

    public final String getCountry() {
        return this.country;
    }

    public final String getVariant() {
        return this.variant;
    }

    public final String toString() {
        if (this.language.length() == 0 && this.country.length() == 0) {
            return "";
        }
        if (this.country.length() == 0 && this.variant.length() == 0) {
            return this.language;
        }
        StringBuffer stringBuffer = new StringBuffer(this.language);
        stringBuffer.append('_').append(this.country);
        if (this.variant.length() != 0) {
            stringBuffer.append('_').append(this.variant);
        }
        return stringBuffer.toString();
    }

    public final String getISO3Language() {
        if (this.language == "") {
            return "";
        }
        int n = "aa,ab,af,am,ar,as,ay,az,ba,be,bg,bh,bi,bn,bo,br,ca,co,cs,cy,da,de,dz,el,en,eo,es,et,eu,fa,fi,fj,fo,fr,fy,ga,gd,gl,gn,gu,ha,iw,hi,hr,hu,hy,ia,in,ie,ik,in,is,it,iu,iw,ja,ji,jw,ka,kk,kl,km,kn,ko,ks,ku,ky,la,ln,lo,lt,lv,mg,mi,mk,ml,mn,mo,mr,ms,mt,my,na,ne,nl,no,oc,om,or,pa,pl,ps,pt,qu,rm,rn,ro,ru,rw,sa,sd,sg,sh,si,sk,sl,sm,sn,so,sq,sr,ss,st,su,sv,sw,ta,te,tg,th,ti,tk,tl,tn,to,tr,ts,tt,tw,ug,uk,ur,uz,vi,vo,wo,xh,ji,yo,za,zh,zu".indexOf(this.language);
        if (n % 3 != 0 || this.language.length() != 2) {
            throw new MissingResourceException("Can't find ISO3 language for " + this.language, "java.util.Locale", this.language);
        }
        return "aarabkaframharaasmaymazebakbelbulbihbisbenbodbrecatcoscescymdandeudzoellengepospaesteusfasfinfijfaofrafrygaigdhglggrngujhauhebhinhrvhunhyeinaindileipkindislitaikuhebjpnyidjawkatkazkalkhmkankorkaskurkirlatlinlaolitlavmlgmrimkdmalmonmolmarmsamltmyanaunepnldnorociormoripanpolpusporquerohrunronruskinsansndsagsrpsinslkslvsmosnasomsqisrpsswsotsunsweswatamteltgkthatirtuktgltsntonturtsotattwiuigukrurduzbvievolwolxhoyidyorzhazhozul".substring(n, n + 3);
    }

    public final String getISO3Country() {
        if (this.country == "") {
            return "";
        }
        int n = "AD,AE,AF,AG,AI,AL,AM,AN,AO,AQ,AR,AS,AT,AU,AW,AZ,BA,BB,BD,BE,BF,BG,BH,BI,BJ,BM,BN,BO,BR,BS,BT,BV,BW,BY,BZ,CA,CC,CF,CG,CH,CI,CK,CL,CM,CN,CO,CR,CU,CV,CX,CY,CZ,DE,DJ,DK,DM,DO,DZ,EC,EE,EG,EH,ER,ES,ET,FI,FJ,FK,FM,FO,FR,FX,GA,GB,GD,GE,GF,GH,GI,GL,GM,GN,GP,GQ,GR,GS,GT,GU,GW,GY,HK,HM,HN,HR,HT,HU,ID,IE,IL,IN,IO,IQ,IR,IS,IT,JM,JO,JP,KE,KG,KH,KI,KM,KN,KP,KR,KW,KY,KZ,LA,LB,LC,LI,LK,LR,LS,LT,LU,LV,LY,MA,MC,MD,MG,MH,MK,ML,MM,MN,MO,MP,MQ,MR,MS,MT,MU,MV,MW,MX,MY,MZ,NA,NC,NE,NF,NG,NI,NL,NO,NP,NR,NU,NZ,OM,PA,PE,PF,PG,PH,PK,PL,PM,PN,PR,PT,PW,PY,QA,RE,RO,RU,RW,SA,SB,SC,SD,SE,SG,SH,SI,SJ,SK,SL,SM,SN,SO,SR,ST,SV,SY,SZ,TC,TD,TF,TG,TH,TJ,TK,TM,TN,TO,TP,TR,TT,TV,TW,TZ,UA,UG,UM,US,UY,UZ,VA,VC,VE,VG,VI,VN,VU,WF,WS,YE,YT,YU,ZA,ZM,ZR,ZW".indexOf(this.country);
        if (n % 3 != 0 || this.country.length() != 2) {
            throw new MissingResourceException("Can't find ISO3 country for " + this.country, "java.util.Locale", this.country);
        }
        return "ANDAREAFGATGAIAALBARMANTAGOATAARGASMAUTAUSABWAZEBIHBRBBGDBELBFABGRBHRBDIBENBMUBRNBOLBRABHSBTNBVTBWABLRBLZCANCCKCAFCOGCHECIVCOKCHLCMRCHNCOLCRICUBCPVCXRCYPCZEDEUDJIDNKDMADOMDZAECUESTEGYESHERIESPETHFINFJIFLKFSMFROFRAFXXGABGBRGRDGEOGUFGHAGIBGRLGMBGINGLPGNQGRCSGSGTMGUMGNBGUYHKGHMDHNDHRVHTIHUNIDNIRLISRINDIOTIRQIRNISLITAJAMJORJPNKENKGZKHMKIRCOMKNAPRKKORKWTCYMKAZLAOLBNLCALIELKALBRLSOLTULUXLVALBYMARMCOMDAMDGMHLMKDMLIMMRMNGMACMNPMTQMRTMSRMLTMUSMDVMWIMEXMYSMOZNAMNCLNERNFKNGANICNLDNORNPLNRUNIUNZLOMNPANPERPYFPNGPHLPAKPOLSPMPCNPRIPRTPLWPRYQATREUROMRUSRWASAUSLBSYCSDNSWESGPSHNSVNSJMSVKSLESMRSENSOMSURSTPSLVSYRSWZTCATCDATFTGOTHATJKTKLTKMTUNTONTMPTURTTOTUVTWNTZAUKRUGAUMIUSAURYUZBVATVCTVENVGBVIRVNMVUTWLFWSMYEMMYTYUGZAFZMBZARZWE".substring(n, n + 3);
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(defaultLocale);
    }

    public final String getDisplayLanguage(Locale locale) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale, ClassLoader.getSystemClassLoader());
            return resourceBundle.getString("languages." + this.language);
        }
        catch (MissingResourceException missingResourceException) {
            return this.language;
        }
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(defaultLocale);
    }

    public final String getDisplayCountry(Locale locale) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale, ClassLoader.getSystemClassLoader());
            return resourceBundle.getString("territories." + this.country);
        }
        catch (MissingResourceException missingResourceException) {
            return this.country;
        }
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(defaultLocale);
    }

    public final String getDisplayVariant(Locale locale) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale, ClassLoader.getSystemClassLoader());
            return resourceBundle.getString("variants." + this.variant);
        }
        catch (MissingResourceException missingResourceException) {
            return this.variant;
        }
    }

    public final String getDisplayName() {
        return this.getDisplayName(defaultLocale);
    }

    public final String getDisplayName(Locale locale) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        String[] stringArray = new String[]{"", " (", ","};
        if (this.language.length() != 0) {
            stringBuffer.append(stringArray[n++]);
            stringBuffer.append(this.getDisplayLanguage(locale));
        }
        if (this.country.length() != 0) {
            stringBuffer.append(stringArray[n++]);
            stringBuffer.append(this.getDisplayCountry(locale));
        }
        if (this.variant.length() != 0) {
            stringBuffer.append(stringArray[n++]);
            stringBuffer.append(this.getDisplayVariant(locale));
        }
        if (n > 1) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public final Object clone() {
        return new Locale(this.language, this.country, this.variant);
    }

    public final int hashCode() {
        return this.hashcode;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Locale)) {
            return false;
        }
        Locale locale = (Locale)object;
        boolean bl = false;
        if (this.language == locale.language && this.country == locale.country && this.variant == locale.variant) {
            bl = true;
        }
        return bl;
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.language);
        objectOutputStream.writeObject(this.country);
        objectOutputStream.writeObject(this.variant);
        objectOutputStream.writeInt(-1);
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.language = ((String)objectInputStream.readObject()).intern();
        this.country = ((String)objectInputStream.readObject()).intern();
        this.variant = ((String)objectInputStream.readObject()).intern();
        this.hashcode = this.language.hashCode() ^ this.country.hashCode() ^ this.variant.hashCode();
    }

    public Locale(String string, String string2, String string3) {
        if (defaultLocale != null) {
            string = this.convertLanguage(string).intern();
            string2 = string2.toUpperCase().intern();
            string3 = string3.intern();
        }
        this.language = string;
        this.country = string2;
        this.variant = string3;
        this.hashcode = string.hashCode() ^ string2.hashCode() ^ string3.hashCode();
    }

    public Locale(String string, String string2) {
        this(string, string2, "");
    }

    public Locale(String string) {
        this(string, "", "");
    }

    static {
        PRC = CHINA = SIMPLIFIED_CHINESE;
        TAIWAN = TRADITIONAL_CHINESE;
        UK = Locale.getLocale("en", "GB");
        US = Locale.getLocale("en", "US");
        CANADA = Locale.getLocale("en", "CA");
        CANADA_FRENCH = Locale.getLocale("fr", "CA");
        defaultLocale = Locale.getLocale(SystemProperties.getProperty("user.language", "en"), SystemProperties.getProperty("user.region", ""), SystemProperties.getProperty("user.variant", ""));
    }
}

