/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class BasicMenuUI
extends BasicMenuItemUI {
    protected ChangeListener changeListener;
    protected MenuListener menuListener;
    protected PropertyChangeListener propertyChangeListener;

    protected ChangeListener createChangeListener(JComponent jComponent) {
        return new ChangeHandler((JMenu)jComponent, this);
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler();
    }

    protected MenuListener createMenuListener(JComponent jComponent) {
        return new MenuHandler();
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new BasicMenuItemUI.PropertyChangeHandler(this);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuUI();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return jComponent.getPreferredSize();
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.menuItem, "Menu.border");
        LookAndFeel.installColorsAndFont(this.menuItem, "Menu.background", "Menu.foreground", "Menu.font");
        this.menuItem.setMargin(UIManager.getInsets("Menu.margin"));
        this.acceleratorFont = UIManager.getFont("Menu.acceleratorFont");
        this.acceleratorForeground = UIManager.getColor("Menu.acceleratorForeground");
        this.acceleratorSelectionForeground = UIManager.getColor("Menu.acceleratorSelectionForeground");
        this.selectionBackground = UIManager.getColor("Menu.selectionBackground");
        this.selectionForeground = UIManager.getColor("Menu.selectionForeground");
        this.arrowIcon = UIManager.getIcon("Menu.arrowIcon");
        this.oldBorderPainted = UIManager.getBoolean("Menu.borderPainted");
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        ((JMenu)this.menuItem).addMouseListener(this.mouseInputListener);
        ((JMenu)this.menuItem).addMouseMotionListener(this.mouseInputListener);
        ((JMenu)this.menuItem).addMenuListener(this.menuListener);
        ((JMenu)this.menuItem).addMenuDragMouseListener(this.menuDragMouseListener);
    }

    protected void setupPostTimer(JMenu jMenu) {
    }

    protected void uninstallDefaults() {
        this.menuItem.setBackground(null);
        this.menuItem.setBorder(null);
        this.menuItem.setFont(null);
        this.menuItem.setForeground(null);
        this.menuItem.setMargin(null);
        this.acceleratorFont = null;
        this.acceleratorForeground = null;
        this.acceleratorSelectionForeground = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.arrowIcon = null;
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        ((JMenu)this.menuItem).removeMouseListener(this.mouseInputListener);
        ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        ((JMenu)this.menuItem).removePropertyChangeListener(this.propertyChangeListener);
    }

    public BasicMenuUI() {
        this.mouseInputListener = this.createMouseInputListener((JMenu)this.menuItem);
        this.menuListener = this.createMenuListener((JMenu)this.menuItem);
        this.propertyChangeListener = this.createPropertyChangeListener((JMenu)this.menuItem);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ChangeHandler
    implements ChangeListener {
        public boolean isSelected;
        public JMenu menu;
        public BasicMenuUI ui;
        public Component wasFocused;

        public void stateChanged(ChangeEvent changeEvent) {
        }

        public ChangeHandler(JMenu jMenu, BasicMenuUI basicMenuUI2) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.setSelectedPath(menuDragMouseEvent.getPath());
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.setSelectedPath(menuDragMouseEvent.getPath());
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        }

        private MenuDragMouseHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MenuKeyHandler
    implements MenuKeyListener {
        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
        }

        private MenuKeyHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MenuHandler
    implements MenuListener {
        public void menuCanceled(MenuEvent menuEvent) {
            this.menuDeselected(menuEvent);
        }

        public void menuDeselected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            if (jMenu.getParent() != null) {
                if (jMenu.isTopLevelMenu()) {
                    ((JMenuBar)jMenu.getParent()).getSelectionModel().clearSelection();
                } else {
                    ((JPopupMenu)jMenu.getParent()).getSelectionModel().clearSelection();
                }
            }
        }

        public void menuSelected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            if (jMenu.isTopLevelMenu()) {
                ((JMenuBar)jMenu.getParent()).setSelected(jMenu);
            } else {
                ((JPopupMenu)jMenu.getParent()).setSelected(jMenu);
            }
        }

        private MenuHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class MouseInputHandler
    implements MouseInputListener {
        public void mouseClicked(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        private final boolean popupVisible() {
            JMenuBar jMenuBar = (JMenuBar)((JMenu)BasicMenuUI.this.menuItem).getParent();
            if (!jMenuBar.isSelected()) {
                return false;
            }
            int n = 0;
            while (n < jMenuBar.getMenuCount()) {
                JMenu jMenu = jMenuBar.getMenu(n);
                if (jMenu != null && jMenu.isPopupMenuVisible()) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            if (!jMenu.isTopLevelMenu() || this.popupVisible()) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                menuSelectionManager.setSelectedPath(BasicMenuUI.this.getPath());
                menuSelectionManager.processMouseEvent(mouseEvent);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            JMenu jMenu = (JMenu)BasicMenuUI.this.menuItem;
            menuSelectionManager.processMouseEvent(mouseEvent);
            if (jMenu.isTopLevelMenu()) {
                if (jMenu.getPopupMenu().isVisible()) {
                    menuSelectionManager.clearSelectedPath();
                } else {
                    boolean bl = false;
                    int n = jMenu.getHeight();
                    menuSelectionManager.setSelectedPath(BasicMenuUI.this.getPath());
                    JMenuBar jMenuBar = (JMenuBar)jMenu.getParent();
                    jMenuBar.getSelectionModel().setSelectedIndex(jMenuBar.getComponentIndex(jMenu));
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
        }

        protected MouseInputHandler() {
        }
    }
}

