--
-- (C) 2013-24 - ntop.org
--
dirs = ntop.getDirs()
package.path = dirs.installdir .. "/scripts/lua/modules/?.lua;" .. package.path
package.path = dirs.installdir .. "/scripts/lua/modules/host/?.lua;" .. package.path
package.path = dirs.installdir .. "/scripts/lua/modules/vulnerability_scan/?.lua;" .. package.path


require "lua_utils"
local rest_utils = require "rest_utils"
local vs_utils = require "vs_utils"

local host = _GET["host"]
local scan_type = _GET["scan_type"]
local scan_return_result = toboolean(_GET["scan_return_result"]) or false
local epoch = _GET["epoch"]

if isEmptyString(host) or isEmptyString(scan_type) then
    rest_utils.answer(rest_utils.consts.err.invalid_args)
end

local result = vs_utils.retrieve_hosts_scan_result(scan_type, host, epoch)
if scan_return_result then
    rest_utils.answer(rest_utils.consts.success.ok, {rsp=result});
else
    local extra_headers = {}

    extra_headers["Content-Disposition"] = "attachment;filename=\"scan_result_export_"..os.time().."_".. host .."_".. scan_type..".txt\""
    rest_utils.vanilla_payload_response(rest_utils.consts.success.ok, result, "application/octet-stream", extra_headers)
end