require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UFS_EXT2FS_EXT2FS_DINODE_H_)) {
    eval 'sub _UFS_EXT2FS_EXT2FS_DINODE_H_ () {1;}' unless defined(&_UFS_EXT2FS_EXT2FS_DINODE_H_);
    if(!defined(&_KERNEL)  && !defined(&_STANDALONE)) {
	require 'stddef.ph';
    }
    require 'sys/stat.ph';
    eval 'sub EXT2_BADBLKINO () {(( &ino_t)1);}' unless defined(&EXT2_BADBLKINO);
    eval 'sub EXT2_ROOTINO () {(( &ino_t)2);}' unless defined(&EXT2_ROOTINO);
    eval 'sub EXT2_ACLIDXINO () {(( &ino_t)3);}' unless defined(&EXT2_ACLIDXINO);
    eval 'sub EXT2_ACLDATAINO () {(( &ino_t)4);}' unless defined(&EXT2_ACLDATAINO);
    eval 'sub EXT2_BOOTLOADERINO () {(( &ino_t)5);}' unless defined(&EXT2_BOOTLOADERINO);
    eval 'sub EXT2_UNDELDIRINO () {(( &ino_t)6);}' unless defined(&EXT2_UNDELDIRINO);
    eval 'sub EXT2_RESIZEINO () {(( &ino_t)7);}' unless defined(&EXT2_RESIZEINO);
    eval 'sub EXT2_JOURNALINO () {(( &ino_t)8);}' unless defined(&EXT2_JOURNALINO);
    eval 'sub EXT2_FIRSTINO () {(( &ino_t)11);}' unless defined(&EXT2_FIRSTINO);
    eval 'sub EXT2FS_NDADDR () {12;}' unless defined(&EXT2FS_NDADDR);
    eval 'sub EXT2FS_NIADDR () {3;}' unless defined(&EXT2FS_NIADDR);
    eval 'sub EXT2_MAXSYMLINKLEN () {(( &EXT2FS_NDADDR+ &EXT2FS_NIADDR) * $sizeof{ &uint32_t});}' unless defined(&EXT2_MAXSYMLINKLEN);
    eval 'sub E2MAXSYMLINKLEN () { &EXT2_MAXSYMLINKLEN;}' unless defined(&E2MAXSYMLINKLEN);
    eval 'sub i_e2fs_mode () { ($i_din->{e2fs_din}->{e2di_mode});}' unless defined(&i_e2fs_mode);
    eval 'sub i_e2fs_uid () { ($i_din->{e2fs_din}->{e2di_uid});}' unless defined(&i_e2fs_uid);
    eval 'sub i_e2fs_size () { ($i_din->{e2fs_din}->{e2di_size});}' unless defined(&i_e2fs_size);
    eval 'sub i_e2fs_atime () { ($i_din->{e2fs_din}->{e2di_atime});}' unless defined(&i_e2fs_atime);
    eval 'sub i_e2fs_ctime () { ($i_din->{e2fs_din}->{e2di_ctime});}' unless defined(&i_e2fs_ctime);
    eval 'sub i_e2fs_mtime () { ($i_din->{e2fs_din}->{e2di_mtime});}' unless defined(&i_e2fs_mtime);
    eval 'sub i_e2fs_dtime () { ($i_din->{e2fs_din}->{e2di_dtime});}' unless defined(&i_e2fs_dtime);
    eval 'sub i_e2fs_gid () { ($i_din->{e2fs_din}->{e2di_gid});}' unless defined(&i_e2fs_gid);
    eval 'sub i_e2fs_nlink () { ($i_din->{e2fs_din}->{e2di_nlink});}' unless defined(&i_e2fs_nlink);
    eval 'sub i_e2fs_nblock () { ($i_din->{e2fs_din}->{e2di_nblock});}' unless defined(&i_e2fs_nblock);
    eval 'sub i_e2fs_flags () { ($i_din->{e2fs_din}->{e2di_flags});}' unless defined(&i_e2fs_flags);
    eval 'sub i_e2fs_version () { ($i_din->{e2fs_din}->{e2di_version});}' unless defined(&i_e2fs_version);
    eval 'sub i_e2fs_blocks () { ($i_din->{e2fs_din}->{e2di_blocks});}' unless defined(&i_e2fs_blocks);
    eval 'sub i_e2fs_rdev () { ($i_din->{e2fs_din}->{e2di_rdev});}' unless defined(&i_e2fs_rdev);
    eval 'sub i_e2fs_gen () { ($i_din->{e2fs_din}->{e2di_gen});}' unless defined(&i_e2fs_gen);
    eval 'sub i_e2fs_facl () { ($i_din->{e2fs_din}->{e2di_facl});}' unless defined(&i_e2fs_facl);
    eval 'sub i_e2fs_nblock_high () { ($i_din->{e2fs_din}->{e2di_nblock_high});}' unless defined(&i_e2fs_nblock_high);
    eval 'sub i_e2fs_facl_high () { ($i_din->{e2fs_din}->{e2di_facl_high});}' unless defined(&i_e2fs_facl_high);
    eval 'sub i_e2fs_uid_high () { ($i_din->{e2fs_din}->{e2di_uid_high});}' unless defined(&i_e2fs_uid_high);
    eval 'sub i_e2fs_gid_high () { ($i_din->{e2fs_din}->{e2di_gid_high});}' unless defined(&i_e2fs_gid_high);
    eval 'sub EXT2_IEXEC () {0000100;}' unless defined(&EXT2_IEXEC);
    eval 'sub EXT2_IWRITE () {0000200;}' unless defined(&EXT2_IWRITE);
    eval 'sub EXT2_IREAD () {0000400;}' unless defined(&EXT2_IREAD);
    eval 'sub EXT2_ISVTX () {0001000;}' unless defined(&EXT2_ISVTX);
    eval 'sub EXT2_ISGID () {0002000;}' unless defined(&EXT2_ISGID);
    eval 'sub EXT2_ISUID () {0004000;}' unless defined(&EXT2_ISUID);
    eval 'sub EXT2_IFMT () {0170000;}' unless defined(&EXT2_IFMT);
    eval 'sub EXT2_IFIFO () {0010000;}' unless defined(&EXT2_IFIFO);
    eval 'sub EXT2_IFCHR () {0020000;}' unless defined(&EXT2_IFCHR);
    eval 'sub EXT2_IFDIR () {0040000;}' unless defined(&EXT2_IFDIR);
    eval 'sub EXT2_IFBLK () {0060000;}' unless defined(&EXT2_IFBLK);
    eval 'sub EXT2_IFREG () {0100000;}' unless defined(&EXT2_IFREG);
    eval 'sub EXT2_IFLNK () {0120000;}' unless defined(&EXT2_IFLNK);
    eval 'sub EXT2_IFSOCK () {0140000;}' unless defined(&EXT2_IFSOCK);
    eval 'sub EXT2_SECRM () {0x1;}' unless defined(&EXT2_SECRM);
    eval 'sub EXT2_UNRM () {0x2;}' unless defined(&EXT2_UNRM);
    eval 'sub EXT2_COMPR () {0x4;}' unless defined(&EXT2_COMPR);
    eval 'sub EXT2_SYNC () {0x8;}' unless defined(&EXT2_SYNC);
    eval 'sub EXT2_IMMUTABLE () {0x10;}' unless defined(&EXT2_IMMUTABLE);
    eval 'sub EXT2_APPEND () {0x20;}' unless defined(&EXT2_APPEND);
    eval 'sub EXT2_NODUMP () {0x40;}' unless defined(&EXT2_NODUMP);
    eval 'sub EXT2_NOATIME () {0x80;}' unless defined(&EXT2_NOATIME);
    eval 'sub EXT2_INDEX () {0x1000;}' unless defined(&EXT2_INDEX);
    eval 'sub EXT2_IMAGIC () {0x2000;}' unless defined(&EXT2_IMAGIC);
    eval 'sub EXT2_JOURNAL_DATA () {0x4000;}' unless defined(&EXT2_JOURNAL_DATA);
    eval 'sub EXT2_NOTAIL () {0x8000;}' unless defined(&EXT2_NOTAIL);
    eval 'sub EXT2_DIRSYNC () {0x10000;}' unless defined(&EXT2_DIRSYNC);
    eval 'sub EXT2_TOPDIR () {0x20000;}' unless defined(&EXT2_TOPDIR);
    eval 'sub EXT2_HUGE_FILE () {0x40000;}' unless defined(&EXT2_HUGE_FILE);
    eval 'sub EXT2_EXTENTS () {0x80000;}' unless defined(&EXT2_EXTENTS);
    eval 'sub EXT2_EA_INODE () {0x200000;}' unless defined(&EXT2_EA_INODE);
    eval 'sub EXT2_EOFBLOCKS () {0x400000;}' unless defined(&EXT2_EOFBLOCKS);
    eval 'sub EXT2_INLINE_DATA () {0x10000000;}' unless defined(&EXT2_INLINE_DATA);
    eval 'sub EXT2_PROJINHERIT () {0x20000000;}' unless defined(&EXT2_PROJINHERIT);
    eval 'sub EXT2_REV0_DINODE_SIZE () {128;}' unless defined(&EXT2_REV0_DINODE_SIZE);
    eval 'sub EXT2_DINODE_SIZE {
        my($fs) = @_;
	    eval q((($fs)-> ($e2fs->{e2fs_rev}) >  &E2FS_REV0 ? ($fs)-> ($e2fs->{e2fs_inode_size}) :  &EXT2_REV0_DINODE_SIZE));
    }' unless defined(&EXT2_DINODE_SIZE);
    eval 'sub EXT2_DINODE_FITS {
        my($dinode, $field, $isize) = @_;
	    eval q(( ($isize >  &EXT2_REV0_DINODE_SIZE)  && (( &EXT2_REV0_DINODE_SIZE + ($dinode)-> &e2di_extra_isize) >=  &offsetof(\'struct ext2fs_dinode\', $field) + $sizeof{($dinode)->$field}) ));
    }' unless defined(&EXT2_DINODE_FITS);
    eval 'sub EXT2_DINODE_TIME_GET {
        my($ts, $dinode, $field, $isize) = @_;
	    eval q( &ext2fs_dinode_time_get($ts, ($dinode)->$field,  &EXT2_DINODE_FITS($dinode, $field   &_extra, $isize) ? ($dinode)->$field   &_extra : 0));
    }' unless defined(&EXT2_DINODE_TIME_GET);
    eval 'sub ext2fs_dinode_time_set {
        my($ts,$epoch,$extra) = @_;
	    eval q({ *$epoch = ( &int32_t)  ($ts->{tv_sec});  &if ($extra) {  &uint32_t  &epoch_bits = ( ($ts->{tv_sec}) >> 32) & 0x3; *$extra = ( ($ts->{tv_nsec}) << 2) |  &epoch_bits; } });
    }' unless defined(&ext2fs_dinode_time_set);
    eval 'sub EXT2_DINODE_TIME_SET {
        my($ts, $dinode, $field, $isize) = @_;
	    eval q( &ext2fs_dinode_time_set($ts, ($dinode)->$field,  &EXT2_DINODE_FITS($dinode, $field   &_extra, $isize) ? ($dinode)->$field   &_extra :  &NULL ));
    }' unless defined(&EXT2_DINODE_TIME_SET);
    eval 'sub e2di_rdev () { $e2di_blocks[0];}' unless defined(&e2di_rdev);
    eval 'sub e2di_shortlink () { &e2di_blocks;}' unless defined(&e2di_shortlink);
    if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
	eval 'sub e2fs_iload {
	    my($old, $new, $isize) = @_;
    	    eval q( &memcpy(($new),($old),($isize)));
	}' unless defined(&e2fs_iload);
	eval 'sub e2fs_isave {
	    my($old, $new, $isize) = @_;
    	    eval q( &memcpy(($new),($old),($isize)));
	}' unless defined(&e2fs_isave);
    } else {
	eval 'sub e2fs_iload {
	    my($old, $new, $isize) = @_;
    	    eval q( &e2fs_i_bswap(($old), ($new), ($isize)));
	}' unless defined(&e2fs_iload);
	eval 'sub e2fs_isave {
	    my($old, $new, $isize) = @_;
    	    eval q( &e2fs_i_bswap(($old), ($new), ($isize)));
	}' unless defined(&e2fs_isave);
    }
}
1;
