/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.scanner;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JList;
import javax.swing.JTree;
import org.parosproxy.paros.extension.ExtensionPopupMenu;
import org.parosproxy.paros.extension.scanner.ExtensionScanner;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteNode;

public class PopupMenuScanHistory
extends ExtensionPopupMenu {
    private ExtensionScanner extension = null;
    private JList listLog = null;

    public PopupMenuScanHistory() {
        this.initialize();
    }

    public PopupMenuScanHistory(String string) {
        super(string);
    }

    private void initialize() {
        this.setText("Scan this History");
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = PopupMenuScanHistory.this.listLog.getSelectedValues();
                if (objectArray.length != 1) {
                    return;
                }
                try {
                    HistoryReference historyReference = (HistoryReference)objectArray[0];
                    SiteNode siteNode = historyReference.getSiteNode();
                    PopupMenuScanHistory.this.extension.startScan(siteNode);
                }
                catch (Exception exception) {
                    PopupMenuScanHistory.this.extension.getView().showWarningDialog("Error getting History.");
                }
            }
        });
    }

    public boolean isEnableForComponent(Component component) {
        if (component.getName() != null && component.getName().equals("ListLog")) {
            try {
                JList jList;
                this.listLog = jList = (JList)component;
                Object[] objectArray = this.listLog.getSelectedValues();
                if (objectArray.length == 1 && this.extension.getScanner().isStop()) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private JTree getTree(Component component) {
        JTree jTree;
        if (component instanceof JTree && (jTree = (JTree)component).getName().equals("treeSite")) {
            return jTree;
        }
        return null;
    }

    void setExtension(ExtensionScanner extensionScanner) {
        this.extension = extensionScanner;
    }
}

