/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqbody;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.bean.ContentType;
import org.wiztools.restclient.bean.ReqEntityStringPartBean;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.reqbody.AddMultipartBaseDialog;
import org.wiztools.restclient.ui.reqbody.AddMultipartPartListener;
import org.wiztools.restclient.ui.reqbody.ContentTypeCharsetComponent;

public class AddMultipartStringDialog
extends AddMultipartBaseDialog {
    @Inject
    private ContentTypeCharsetComponent jp_contentType;
    private JTextField jtf_name = new JTextField(26);
    private RSyntaxTextArea jta_part = new RSyntaxTextArea(25, 60);
    private JButton jb_add = new JButton("Add");
    private JButton jb_addAndClose = new JButton("Add & close");
    private JButton jb_cancel = new JButton("Cancel");

    @Inject
    public AddMultipartStringDialog(RESTUserInterface rest_ui) {
        super(rest_ui);
        this.setTitle("Add Multipart String");
    }

    @PostConstruct
    protected void init() {
        this.jta_part.setAntiAliasingEnabled(true);
        this.jb_add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddMultipartStringDialog.this.add();
            }
        });
        this.jb_addAndClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddMultipartStringDialog.this.addAndClose();
            }
        });
        this.jb_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddMultipartStringDialog.this.cancel();
            }
        });
        this.getRootPane().setDefaultButton(this.jb_add);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        JPanel jp = new JPanel(new BorderLayout());
        JPanel jp_west = new JPanel(new GridLayout(2, 1));
        jp_west.add(new JLabel(" Content type: "));
        jp_west.add(new JLabel(" Name: "));
        jp.add((Component)jp_west, "West");
        JPanel jp_center = new JPanel(new GridLayout(2, 1));
        jp_center.add(this.jp_contentType.getComponent());
        jp_center.add(UIUtil.getFlowLayoutPanelLeftAligned(this.jtf_name));
        jp.add((Component)jp_center, "Center");
        c.add((Component)jp, "North");
        JScrollPane jsp = new JScrollPane(this.jta_part);
        c.add((Component)jsp, "Center");
        jp = new JPanel();
        jp.setLayout(new FlowLayout(2));
        jp.add(this.jb_cancel);
        jp.add(this.jb_add);
        jp.add(this.jb_addAndClose);
        c.add((Component)jp, "South");
        this.pack();
    }

    private boolean add() {
        if (StringUtil.isEmpty(this.jtf_name.getText())) {
            JOptionPane.showMessageDialog(this, "Name must be present!", "Validation: name empty!", 0);
            this.jtf_name.requestFocus();
            return false;
        }
        String name = this.jtf_name.getText();
        ContentType ct = this.jp_contentType.getContentType();
        String body = this.jta_part.getText();
        ReqEntityStringPartBean part = new ReqEntityStringPartBean(name, ct, body);
        for (AddMultipartPartListener l : this.listeners) {
            l.addPart(part);
        }
        this.clear();
        this.jtf_name.requestFocus();
        return true;
    }

    private void addAndClose() {
        if (this.add()) {
            this.setVisible(false);
        }
    }

    private void cancel() {
        this.clear();
        this.setVisible(false);
    }

    @Override
    public void clear() {
        this.jp_contentType.clear();
        this.jtf_name.setText("");
        this.jta_part.setText("");
    }

    @Override
    public void setVisible(boolean boo) {
        this.jp_contentType.requestFocus();
        super.setVisible(boo);
    }
}

