/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.net.VMInetAddress;
import java.util.HashMap;
import java.util.StringTokenizer;

public class InetAddress
implements Serializable {
    private static final long serialVersionUID = 3286316764910316507L;
    private static final int DEFAULT_CACHE_SIZE = 89;
    private static final int DEFAULT_CACHE_PERIOD = 240;
    private static final int DEFAULT_CACHE_PURGE_PCT = 30;
    private static InetAddress inaddr_any;
    static InetAddress ANY_IF;
    static InetAddress LOCALHOST;
    private static int cache_size;
    private static int cache_period;
    private static int cache_purge_pct;
    private static HashMap cache;
    private int address;
    transient byte[] addr;
    String hostName;
    transient long lookup_time;
    int family;

    public boolean isMulticastAddress() {
        if (this.addr.length == 4) {
            boolean bl = false;
            if ((this.addr[0] & 0xF0) == 224) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public boolean isAnyLocalAddress() {
        return this.equals(ANY_IF);
    }

    public boolean isLoopbackAddress() {
        boolean bl = false;
        if ((this.addr[0] & 0xFF) == 127) {
            bl = true;
        }
        return bl;
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        if ((this.addr[0] & 0xFF) == 10) {
            return true;
        }
        if ((this.addr[0] & 0xFF) == 172 && (this.addr[1] & 0xF0) == 16) {
            return true;
        }
        return (this.addr[0] & 0xFF) == 192 && (this.addr[1] & 0xFF) == 168;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        boolean bl = false;
        if ((this.addr[0] & 0xFF) == 224 && (this.addr[1] & 0xFF) == 0 && (this.addr[2] & 0xFF) == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public String getHostName() {
        if (this.hostName != null) {
            return this.hostName;
        }
        try {
            this.hostName = VMInetAddress.getHostByAddr(this.addr);
            return this.hostName;
        }
        catch (UnknownHostException e) {
            return this.getHostAddress();
        }
    }

    public String getCanonicalHostName() {
        byte[] ipaddr;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkConnect(this.hostName, -1);
            }
            catch (SecurityException e) {
                return this.getHostAddress();
            }
        }
        InetAddress address = (ipaddr = this.getAddress()).length == 16 ? new Inet6Address(this.getAddress(), null) : new Inet4Address(this.getAddress(), null);
        return address.getHostName();
    }

    public byte[] getAddress() {
        return (byte[])this.addr.clone();
    }

    public String getHostAddress() {
        StringBuffer sb = new StringBuffer(40);
        int len = this.addr.length;
        int i = 0;
        while (true) {
            sb.append(this.addr[i] & 0xFF);
            if (++i == len) break;
            sb.append('.');
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 0;
        int len = this.addr.length;
        int n = 0;
        if (len > 4) {
            n = len - 4;
        }
        int i = n;
        while (i < len) {
            hash = hash << 8 | this.addr[i] & 0xFF;
            ++i;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InetAddress)) {
            return false;
        }
        byte[] addr2 = ((InetAddress)obj).addr;
        if (this.addr.length != addr2.length) {
            return false;
        }
        int i = 0;
        while (i < this.addr.length) {
            if (this.addr[i] != addr2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String addr = this.getHostAddress();
        String host = this.hostName != null ? this.hostName : "";
        return host + '/' + addr;
    }

    public static InetAddress getByAddress(byte[] addr) throws UnknownHostException {
        return InetAddress.getByAddress(null, addr);
    }

    public static InetAddress getByAddress(String host, byte[] addr) throws UnknownHostException {
        if (addr.length == 4) {
            return new Inet4Address(addr, host);
        }
        if (addr.length == 16) {
            return new Inet6Address(addr, host);
        }
        throw new UnknownHostException("IP address has illegal length");
    }

    private static final byte[] aton(String hostname) {
        StringTokenizer st = new StringTokenizer(hostname, ".");
        if (st.countTokens() == 4) {
            byte[] address = new byte[4];
            int index = 0;
            while (index < 4) {
                try {
                    short n = Short.parseShort(st.nextToken());
                    if (n < 0 || n > 255) break;
                    address[index] = (byte)n;
                }
                catch (NumberFormatException e) {
                    break;
                }
                ++index;
            }
            if (index == 4) {
                return address;
            }
        }
        return null;
    }

    public static InetAddress getByName(String hostname) throws UnknownHostException {
        InetAddress[] addresses = InetAddress.getAllByName(hostname);
        return addresses[0];
    }

    public static InetAddress[] getAllByName(String hostname) throws UnknownHostException {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkConnect(hostname, -1);
        }
        if (hostname == null) {
            InetAddress[] addresses = new InetAddress[]{LOCALHOST};
            return addresses;
        }
        InetAddress[] addresses = InetAddress.checkCacheFor(hostname);
        if (addresses != null) {
            return addresses;
        }
        byte[][] iplist = VMInetAddress.getHostByName(hostname);
        if (iplist.length == 0) {
            throw new UnknownHostException(hostname);
        }
        addresses = new InetAddress[iplist.length];
        int i = 0;
        while (i < iplist.length) {
            if (iplist[i].length != 4) {
                throw new UnknownHostException(hostname);
            }
            addresses[i] = new Inet4Address(iplist[i], hostname);
            ++i;
        }
        InetAddress.addToCache(hostname, addresses);
        return addresses;
    }

    private static final synchronized InetAddress[] checkCacheFor(String hostname) {
        InetAddress[] addresses = null;
        if (cache_size == 0) {
            return null;
        }
        Object obj = cache.get(hostname);
        if (obj == null) {
            return null;
        }
        if (obj instanceof InetAddress[]) {
            addresses = (InetAddress[])obj;
        }
        if (addresses == null) {
            return null;
        }
        if (cache_period != -1 && System.currentTimeMillis() - addresses[0].lookup_time > (long)cache_period) {
            cache.remove(hostname);
            return null;
        }
        return addresses;
    }

    private static final synchronized void addToCache(String hostname, Object obj) {
        if (cache_size == 0) {
            return;
        }
        if (cache_size != -1) {
            cache.size();
        }
        cache.put(hostname, obj);
    }

    static InetAddress getInaddrAny() throws UnknownHostException {
        if (inaddr_any == null) {
            byte[] tmp = VMInetAddress.lookupInaddrAny();
            inaddr_any = new Inet4Address(tmp, null);
        }
        return inaddr_any;
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        String hostname = VMInetAddress.getLocalHostname();
        return InetAddress.getByName(hostname);
    }

    private final void readResolve() throws ObjectStreamException {
    }

    private final void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.addr = new byte[4];
        this.addr[3] = (byte)this.address;
        int i = 2;
        while (i >= 0) {
            this.addr[i] = (byte)(this.address >>= 8);
            --i;
        }
        this.family = 2;
    }

    private final void writeObject(ObjectOutputStream oos) throws IOException {
        int len = this.addr.length;
        int i = len - 4;
        while (i < len) {
            this.address = this.address << 8 | this.addr[i] & 0xFF;
            ++i;
        }
        oos.defaultWriteObject();
    }

    InetAddress(byte[] ipaddr, String hostname) {
        this.addr = ipaddr == null ? null : (byte[])ipaddr.clone();
        this.hostName = hostname;
        this.lookup_time = System.currentTimeMillis();
        this.family = 2;
    }

    static {
        cache_size = 0;
        cache_period = 0;
        cache_purge_pct = 0;
        cache_size = Integer.getInteger("gnu.java.net.dns_cache_size", 89);
        cache_period = Integer.getInteger("gnu.java.net.dns_cache_period", 14400000);
        cache_purge_pct = Integer.getInteger("gnu.java.net.dns_cache_purge_pct", 30);
        if (cache_purge_pct < 1 || cache_purge_pct > 100) {
            cache_purge_pct = 30;
        }
        if (cache_size != 0) {
            cache = new HashMap(cache_size);
        }
        try {
            ANY_IF = InetAddress.getInaddrAny();
            byte[] byArray = new byte[4];
            byArray[0] = 127;
            byArray[3] = 1;
            byte[] ip_localhost = byArray;
            LOCALHOST = new Inet4Address(ip_localhost, "localhost");
        }
        catch (UnknownHostException uhe) {
            byte[] zeros = new byte[4];
            ANY_IF = new Inet4Address(zeros, "0.0.0.0");
        }
    }
}

