/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.sra;

import htsjdk.samtools.SAMFileHeader;
import ngs.ErrorMsg;
import ngs.ReadCollection;
import ngs.Reference;

public class ReferenceCache {
    private ReadCollection run;
    private SAMFileHeader virtualHeader;
    private Reference cachedReference;

    public ReferenceCache(ReadCollection run, SAMFileHeader virtualHeader) {
        this.run = run;
        this.virtualHeader = virtualHeader;
    }

    public Reference get(int referenceIndex) {
        String contig = this.virtualHeader.getSequence(referenceIndex).getSequenceName();
        try {
            if (this.cachedReference == null || !this.cachedReference.getCanonicalName().equals(contig)) {
                this.cachedReference = this.run.getReference(contig);
            }
        }
        catch (ErrorMsg e) {
            throw new RuntimeException(e);
        }
        return this.cachedReference;
    }
}

