require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__HTM__)) {
    die("HTM instruction set not enabled");
}
unless(defined(&_HTMINTRIN_H)) {
    eval 'sub _HTMINTRIN_H () {1;}' unless defined(&_HTMINTRIN_H);
    require 'stdint.ph';
    eval 'sub _HTM_STATE {
        my($CR0) = @_;
	    eval q((($CR0 >> 1) & 0x3));
    }' unless defined(&_HTM_STATE);
    eval 'sub _HTM_NONTRANSACTIONAL () {0x;}' unless defined(&_HTM_NONTRANSACTIONAL);
    eval 'sub _HTM_SUSPENDED () {0x1;}' unless defined(&_HTM_SUSPENDED);
    eval 'sub _HTM_TRANSACTIONAL () {0x2;}' unless defined(&_HTM_TRANSACTIONAL);
    eval 'sub _TEXASR_EXTRACT_BITS {
        my($TEXASR,$BITNUM,$SIZE) = @_;
	    eval q(((($TEXASR) >> (63-($BITNUM))) & ((1<<($SIZE))-1)));
    }' unless defined(&_TEXASR_EXTRACT_BITS);
    eval 'sub _TEXASRU_EXTRACT_BITS {
        my($TEXASR,$BITNUM,$SIZE) = @_;
	    eval q(((($TEXASR) >> (31-($BITNUM))) & ((1<<($SIZE))-1)));
    }' unless defined(&_TEXASRU_EXTRACT_BITS);
    eval 'sub _TEXASR_FAILURE_CODE {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 7, 8));
    }' unless defined(&_TEXASR_FAILURE_CODE);
    eval 'sub _TEXASRU_FAILURE_CODE {
        my($TEXASRU) = @_;
	    eval q( &_TEXASRU_EXTRACT_BITS($TEXASRU, 7, 8));
    }' unless defined(&_TEXASRU_FAILURE_CODE);
    eval 'sub _TEXASR_FAILURE_PERSISTENT {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 7, 1));
    }' unless defined(&_TEXASR_FAILURE_PERSISTENT);
    eval 'sub _TEXASRU_FAILURE_PERSISTENT {
        my($TEXASRU) = @_;
	    eval q( &_TEXASRU_EXTRACT_BITS($TEXASRU, 7, 1));
    }' unless defined(&_TEXASRU_FAILURE_PERSISTENT);
    eval 'sub _TEXASR_DISALLOWED {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 8, 1));
    }' unless defined(&_TEXASR_DISALLOWED);
    eval 'sub _TEXASRU_DISALLOWED {
        my($TEXASRU) = @_;
	    eval q( &_TEXASRU_EXTRACT_BITS($TEXASRU, 8, 1));
    }' unless defined(&_TEXASRU_DISALLOWED);
    eval 'sub _TEXASR_NESTING_OVERFLOW {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 9, 1));
    }' unless defined(&_TEXASR_NESTING_OVERFLOW);
    eval 'sub _TEXASRU_NESTING_OVERFLOW {
        my($TEXASRU) = @_;
	    eval q( &_TEXASRU_EXTRACT_BITS($TEXASRU, 9, 1));
    }' unless defined(&_TEXASRU_NESTING_OVERFLOW);
    eval 'sub _TEXASR_FOOTPRINT_OVERFLOW {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 10, 1));
    }' unless defined(&_TEXASR_FOOTPRINT_OVERFLOW);
    eval 'sub _TEXASRU_FOOTPRINT_OVERFLOW {
        my($TEXASRU) = @_;
	    eval q( &_TEXASRU_EXTRACT_BITS($TEXASRU, 10, 1));
    }' unless defined(&_TEXASRU_FOOTPRINT_OVERFLOW);
    eval 'sub _TEXASR_SELF_INDUCED_CONFLICT {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 11, 1));
    }' unless defined(&_TEXASR_SELF_INDUCED_CONFLICT);
    eval 'sub _TEXASRU_SELF_INDUCED_CONFLICT {
        my($TEXASRU) = @_;
	    eval q( &_TEXASRU_EXTRACT_BITS($TEXASRU, 11, 1));
    }' unless defined(&_TEXASRU_SELF_INDUCED_CONFLICT);
    eval 'sub _TEXASR_NON_TRANSACTIONAL_CONFLICT {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 12, 1));
    }' unless defined(&_TEXASR_NON_TRANSACTIONAL_CONFLICT);
    eval 'sub _TEXASRU_NON_TRANSACTIONAL_CONFLICT {
        my($TEXASRU) = @_;
	    eval q( &_TEXASRU_EXTRACT_BITS($TEXASRU, 12, 1));
    }' unless defined(&_TEXASRU_NON_TRANSACTIONAL_CONFLICT);
    eval 'sub _TEXASR_TRANSACTION_CONFLICT {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 13, 1));
    }' unless defined(&_TEXASR_TRANSACTION_CONFLICT);
    eval 'sub _TEXASRU_TRANSACTION_CONFLICT {
        my($TEXASRU) = @_;
	    eval q( &_TEXASRU_EXTRACT_BITS($TEXASRU, 13, 1));
    }' unless defined(&_TEXASRU_TRANSACTION_CONFLICT);
    eval 'sub _TEXASR_TRANSLATION_INVALIDATION_CONFLICT {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 14, 1));
    }' unless defined(&_TEXASR_TRANSLATION_INVALIDATION_CONFLICT);
    eval 'sub _TEXASRU_TRANSLATION_INVALIDATION_CONFLICT {
        my($TEXASRU) = @_;
	    eval q( &_TEXASRU_EXTRACT_BITS($TEXASRU, 14, 1));
    }' unless defined(&_TEXASRU_TRANSLATION_INVALIDATION_CONFLICT);
    eval 'sub _TEXASR_IMPLEMENTAION_SPECIFIC {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 15, 1));
    }' unless defined(&_TEXASR_IMPLEMENTAION_SPECIFIC);
    eval 'sub _TEXASRU_IMPLEMENTAION_SPECIFIC {
        my($TEXASRU) = @_;
	    eval q( &_TEXASRU_EXTRACT_BITS($TEXASRU, 15, 1));
    }' unless defined(&_TEXASRU_IMPLEMENTAION_SPECIFIC);
    eval 'sub _TEXASR_INSTRUCTION_FETCH_CONFLICT {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 16, 1));
    }' unless defined(&_TEXASR_INSTRUCTION_FETCH_CONFLICT);
    eval 'sub _TEXASRU_INSTRUCTION_FETCH_CONFLICT {
        my($TEXASRU) = @_;
	    eval q( &_TEXASRU_EXTRACT_BITS($TEXASRU, 16, 1));
    }' unless defined(&_TEXASRU_INSTRUCTION_FETCH_CONFLICT);
    eval 'sub _TEXASR_ABORT {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 31, 1));
    }' unless defined(&_TEXASR_ABORT);
    eval 'sub _TEXASRU_ABORT {
        my($TEXASRU) = @_;
	    eval q( &_TEXASRU_EXTRACT_BITS($TEXASRU, 31, 1));
    }' unless defined(&_TEXASRU_ABORT);
    eval 'sub _TEXASR_SUSPENDED {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 32, 1));
    }' unless defined(&_TEXASR_SUSPENDED);
    eval 'sub _TEXASR_PRIVILEGE {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 35, 2));
    }' unless defined(&_TEXASR_PRIVILEGE);
    eval 'sub _TEXASR_FAILURE_SUMMARY {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 36, 1));
    }' unless defined(&_TEXASR_FAILURE_SUMMARY);
    eval 'sub _TEXASR_TFIAR_EXACT {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 37, 1));
    }' unless defined(&_TEXASR_TFIAR_EXACT);
    eval 'sub _TEXASR_ROT {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 38, 1));
    }' unless defined(&_TEXASR_ROT);
    eval 'sub _TEXASR_TRANSACTION_LEVEL {
        my($TEXASR) = @_;
	    eval q( &_TEXASR_EXTRACT_BITS($TEXASR, 63, 12));
    }' unless defined(&_TEXASR_TRANSACTION_LEVEL);
}
1;
