###############################################################################
# NOTE: This is an autogenerated file, based on "best guesses" of
# rfnoc_modtool. Almost always, this file requires some manual work to get
# it to work properly. It is recommended to go through all the sections of
# this file and adjust them to your needs.
###############################################################################
id: rfnoc_${  MODULE_NAME }_${ blockname }
label: RFNoC Gain Block (Generic Version)
category: '[rfnoc_${ MODULE_NAME }]'

templates:
% if bindings_type == "generic":
  # We create a 'generic' block here, meaning there is no native GNU Radio
  # block available for this RFNoC block. Instead, we use the
  # uhd.rfnoc_block_generic() block from gr-uhd, which only allows configuring
  # the block through the property API.
  imports: from gnuradio import uhd
  make: |-
    uhd.rfnoc_block_generic(
        self.rfnoc_graph,
        uhd.device_addr(""), # TODO Here, you can pass in initial user property key/value pairs
        "${ blockname.capitalize() }", # TODO Match this to the registered block name in the block controller, if not done so already
        ${'$'}{device_select},
        ${'$'}{instance_index})
% else:
  imports: from gnuradio import rfnoc_${ MODULE_NAME }
  # TODO: The make function needs to be adjusted to match the actual call
  # signature of the RFNoC block. Arguments to the factory call are most likely
  # also parameters of this GRC block, so they need to be added to the list of
  # parameters below.
  make: rfnoc_${ MODULE_NAME }.${ blockname }(
        self.rfnoc_graph,
        uhd.device_addr(""),
        ${'$'}{device_select},
        ${'$'}{instance_index})
  # Any API calls of your GNU Radio block that are exposed as callbacks in GRC
  # need to be listed here:
  #callbacks:
  #  - set_foo(${'$'}{bar})
% endif


parameters:
# TODO: Add all parameters here. The parameters device_select and instance_index
# are required, unless there's a C++ block controller available that does
# something different.
- id: device_select
  label: Device Select
  dtype: int
  default: -1
  hide: ${'$'}{ 'part' if device_select == -1 else 'none' }
- id: instance_index
  label: Instance Select
  dtype: int
  default: -1
  hide: ${'$'}{ 'part' if instance_index == -1 else 'none' }
# Append all missing parameters here.

# TODO: The inputs and outputs are generated directly from the data ports of the
# RFNoC block YAML.
# Legend:
# - label: The label of the port, which is used in the GRC block.
# - domain: This must be 'rfnoc' if the port is an RFNoC data port. An
#           advanced use case would be to create a message port for a GNU Radio
#           RFNoC block controller, which would then have the domain 'message'.
# - dtype: The data type of the port, e.g., 'sc16' for complex 16-bit signed
#          data.
# - optional: Whether the port is optional or not. If set to false, the port
#             must always be connected, or the RFNoC flow graph won't work.
# - multiplicity: The number of ports that are created for this port. For example,
#                 if set to a number greater than 1, and the port label is 'in',
#                 then the GRC block will have multiple input ports named 'in_0',
#                 'in_1', etc. This value can be a parameter, it does not have
#                 to be a constant.
inputs:
% for port_id, port_info in config.get('data', {}).get('inputs', {}).items():
- label: ${ port_id }
  domain: rfnoc
  dtype: ${ port_info.get('format', 'sc16') }
  vlen: 1
  optional: true
  % if str(port_info.get('num_ports', '1')) != '1':
  multiplicity: ${ port_info.get('num_ports') }
  % endif
% endfor

outputs:
% for input_id, input_info in config.get('data', {}).get('inputs', {}).items():
- label: ${ port_id }
  domain: rfnoc
  dtype: ${ port_info.get('format', 'sc16') }
  vlen: 1
  optional: true
  % if str(port_info.get('num_ports', '1')) != '1':
  multiplicity: ${ port_info.get('num_ports') }
  % endif
% endfor

# TODO: Optionally, add documentation here which can be viewed in the corresponding
# tab in GNU Radio Companion.
#documentation: |-
  #My RFNoC Block: Does cool things with RFNoC data streams.

file_format: 1
