/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

public class X25Record
extends Record {
    private byte[] address;

    Record getObject() {
        return new X25Record();
    }

    private static final byte[] checkAndConvertAddress(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!Character.isDigit(c)) {
                return null;
            }
            byArray[n2] = (byte)c;
            ++n2;
        }
        return byArray;
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.address = dNSInput.readCountedString();
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        String string = tokenizer.getString();
        this.address = X25Record.checkAndConvertAddress(string);
        if (this.address == null) {
            throw tokenizer.exception("invalid PSDN address " + string);
        }
    }

    public String getAddress() {
        return X25Record.byteArrayToString(this.address, false);
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeCountedString(this.address);
    }

    String rrToString() {
        return X25Record.byteArrayToString(this.address, true);
    }

    X25Record() {
    }

    public X25Record(Name name, int n, long l, String string) {
        super(name, 19, n, l);
        this.address = X25Record.checkAndConvertAddress(string);
        if (this.address == null) {
            throw new IllegalArgumentException("invalid PSDN address " + string);
        }
    }
}

