/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import com.glavsoft.rfb.encoding.EncodingType;
import com.glavsoft.rfb.protocol.LocalPointer;
import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.UiSettings;
import com.glavsoft.viewer.cli.Parser;
import com.glavsoft.viewer.swing.ConnectionParams;
import com.glavsoft.viewer.swing.WrongParameterException;
import javax.swing.JApplet;

public class ParametersHandler {
    public static final String ARG_LOCAL_POINTER = "LocalPointer";
    public static final String ARG_SCALING_FACTOR = "ScalingFactor";
    public static final String ARG_FULL_SCREEN = "FullScreen";
    public static final String ARG_COLOR_DEPTH = "ColorDepth";
    public static final String ARG_JPEG_IMAGE_QUALITY = "JpegImageQuality";
    public static final String ARG_COMPRESSION_LEVEL = "CompressionLevel";
    public static final String ARG_ENCODING = "Encoding";
    public static final String ARG_SHARE_DESKTOP = "ShareDesktop";
    public static final String ARG_ALLOW_COPY_RECT = "AllowCopyRect";
    public static final String ARG_VIEW_ONLY = "ViewOnly";
    public static final String ARG_SHOW_CONTROLS = "ShowControls";
    public static final String ARG_OPEN_NEW_WINDOW = "OpenNewWindow";
    public static final String ARG_PASSWORD = "password";
    public static final String ARG_PORT = "port";
    public static final String ARG_HOST = "host";
    public static final String ARG_HELP = "help";
    public static final String ARG_VERBOSE = "v";
    public static final String ARG_VERBOSE_MORE = "vv";
    public static final String ARG_CONVERT_TO_ASCII = "ConvertToASCII";
    public static final String ARG_ALLOW_CLIPBOARD_TRANSFER = "AllowClipboardTransfer";
    public static final String ARG_REMOTE_CHARSET = "RemoteCharset";
    public static final String ARG_SSH_HOST = "sshHost";
    public static final String ARG_SSH_USER = "sshUser";
    public static final String ARG_SSH_PORT = "sshPort";
    public static final String ARG_ALLOW_APPLET_INTERACTIVE_CONNECTIONS = "AllowAppletInteractiveConnections";
    public static boolean isSeparateFrame;
    public static boolean allowAppletInteractiveConnections;

    public static void completeParserOptions(Parser parser) {
        parser.addOption(ARG_HELP, null, "Print this help.");
        parser.addOption(ARG_HOST, "", "Server host name.");
        parser.addOption(ARG_PORT, "0", "Port number.");
        parser.addOption(ARG_PASSWORD, null, "Password to the server.");
        parser.addOption(ARG_SHOW_CONTROLS, null, "Set to \"No\" if you want to get rid of that button panel at the top. Default: \"Yes\".");
        parser.addOption(ARG_VIEW_ONLY, null, "When set to \"Yes\", then all keyboard and mouse events in the desktop window will be silently ignored and will not be passed to the remote side. Default: \"No\".");
        parser.addOption(ARG_ALLOW_CLIPBOARD_TRANSFER, null, "When set to \"Yes\", transfer of clipboard contents is allowed. Default: \"Yes\".");
        parser.addOption(ARG_REMOTE_CHARSET, null, "Charset encoding is used on remote system. Use this option to specify character encoding will be used for encoding clipboard text content to. Default value: local system default character encoding. Set the value to 'standard' for using 'Latin-1' charset which is only specified by rfb standard for clipboard transfers.");
        parser.addOption(ARG_SHARE_DESKTOP, null, "Share the connection with other clients on the same VNC server. The exact behaviour in each case depends on the server configuration. Default: \"Yes\".");
        parser.addOption(ARG_ALLOW_COPY_RECT, null, "The \"CopyRect\" encoding saves bandwidth and drawing time when parts of the remote screen are moving around. Most likely, you don't want to change this setting. Default: \"Yes\".");
        parser.addOption(ARG_ENCODING, null, "The preferred encoding. Possible values: \"Tight\", \"Hextile\", \"ZRLE\", and \"Raw\". Default: \"Tight\".");
        parser.addOption(ARG_COMPRESSION_LEVEL, null, "Use specified compression level for \"Tight\" and \"Zlib\" encodings. Values: 1-9. Level 1 uses minimum of CPU time on the server but achieves weak compression ratios. Level 9 offers best compression but may be slow.");
        parser.addOption(ARG_JPEG_IMAGE_QUALITY, null, "Use the specified image quality level in \"Tight\" encoding. Values: 1-9, Lossless. Default value: " + String.valueOf(6) + ". To prevent server of using " + "lossy JPEG compression in \"Tight\" encoding, use \"Lossless\" value here.");
        parser.addOption(ARG_LOCAL_POINTER, null, "Possible values: on/yes/true (draw pointer locally), off/no/false (let server draw pointer), hide). Default: \"On\".");
        parser.addOption(ARG_CONVERT_TO_ASCII, null, "Whether to convert keyboard input to ASCII ignoring locale. Possible values: yes/true, no/false). Default: \"No\".");
        parser.addOption(ARG_COLOR_DEPTH, null, "Bits per pixel color format. Possible values: 3 (for 8 colors), 6 (64 colors), 8 (256 colors), 16 (65 536 colors), 24 (16 777 216 colors), 32 (same as 24).");
        parser.addOption(ARG_SCALING_FACTOR, null, "Scale local representation of the remote desktop on startup. The value is interpreted as scaling factor in percents. The default value of 100% corresponds to the original framebuffer size.");
        parser.addOption(ARG_FULL_SCREEN, null, "Full screen mode. Possible values: yes/true and no/false. Default: no.");
        parser.addOption(ARG_SSH_HOST, "", "SSH host name.");
        parser.addOption(ARG_SSH_PORT, "0", "SSH port number. When empty, standard SSH port number (22) is used.");
        parser.addOption(ARG_SSH_USER, "", "SSH user name.");
        parser.addOption(ARG_ALLOW_APPLET_INTERACTIVE_CONNECTIONS, null, "Allow applet interactively connect to other hosts then in HostName param or hostbase. Possible values: yes/true, no/false. Default: false.");
        parser.addOption(ARG_VERBOSE, null, "Verbose console output.");
        parser.addOption(ARG_VERBOSE_MORE, null, "More verbose console output.");
    }

    public static int completeSettingsFromCLI(final Parser parser, ConnectionParams connectionParams, ProtocolSettings rfbSettings, UiSettings uiSettings) {
        int mask = ParametersHandler.completeSettings(new ParamsRetriever(){

            @Override
            public String getParamByName(String name) {
                return parser.getValueFor(name);
            }
        }, connectionParams, rfbSettings, uiSettings);
        if (!Strings.isTrimmedEmpty(connectionParams.hostName)) {
            ParametersHandler.splitConnectionParams(connectionParams, connectionParams.hostName);
        }
        if (parser.isSetPlainOptions()) {
            ParametersHandler.splitConnectionParams(connectionParams, parser.getPlainOptionAt(0));
            if (parser.getPlainOptionsNumber() > 1) {
                try {
                    connectionParams.parseRfbPortNumber(parser.getPlainOptionAt(1));
                }
                catch (WrongParameterException e) {
                    // empty catch block
                }
            }
        }
        return mask;
    }

    public static void splitConnectionParams(ConnectionParams connectionParams, String host) {
        int indexOfColon = host.indexOf(58);
        if (indexOfColon > 0) {
            String[] splitted = host.split(":");
            connectionParams.hostName = splitted[0];
            if (splitted.length > 1) {
                try {
                    connectionParams.parseRfbPortNumber(splitted[splitted.length - 1]);
                }
                catch (WrongParameterException e) {}
            }
        } else {
            connectionParams.hostName = host;
        }
    }

    private static int completeSettings(ParamsRetriever pr, ConnectionParams connectionParams, ProtocolSettings rfbSettings, UiSettings uiSettings) {
        int rfbMask;
        String localPointerParam;
        String fullScreenParam;
        String scaleFactorParam;
        String colorDepthParam;
        block27: {
            String hostName = pr.getParamByName(ARG_HOST);
            String portNumber = pr.getParamByName(ARG_PORT);
            String showControlsParam = pr.getParamByName(ARG_SHOW_CONTROLS);
            String viewOnlyParam = pr.getParamByName(ARG_VIEW_ONLY);
            String allowClipboardTransfer = pr.getParamByName(ARG_ALLOW_CLIPBOARD_TRANSFER);
            String remoteCharsetName = pr.getParamByName(ARG_REMOTE_CHARSET);
            String allowCopyRectParam = pr.getParamByName(ARG_ALLOW_COPY_RECT);
            String shareDesktopParam = pr.getParamByName(ARG_SHARE_DESKTOP);
            String encodingParam = pr.getParamByName(ARG_ENCODING);
            String compressionLevelParam = pr.getParamByName(ARG_COMPRESSION_LEVEL);
            String jpegQualityParam = pr.getParamByName(ARG_JPEG_IMAGE_QUALITY);
            colorDepthParam = pr.getParamByName(ARG_COLOR_DEPTH);
            scaleFactorParam = pr.getParamByName(ARG_SCALING_FACTOR);
            fullScreenParam = pr.getParamByName(ARG_FULL_SCREEN);
            localPointerParam = pr.getParamByName(ARG_LOCAL_POINTER);
            String convertToAsciiParam = pr.getParamByName(ARG_CONVERT_TO_ASCII);
            String sshHostNameParam = pr.getParamByName(ARG_SSH_HOST);
            String sshPortNumberParam = pr.getParamByName(ARG_SSH_PORT);
            String sshUserNameParam = pr.getParamByName(ARG_SSH_USER);
            connectionParams.hostName = hostName;
            try {
                connectionParams.parseRfbPortNumber(portNumber);
            }
            catch (WrongParameterException e) {
                // empty catch block
            }
            connectionParams.sshHostName = sshHostNameParam;
            connectionParams.setUseSsh(!Strings.isTrimmedEmpty(sshHostNameParam));
            connectionParams.parseSshPortNumber(sshPortNumberParam);
            connectionParams.sshUserName = sshUserNameParam;
            rfbMask = 0;
            uiSettings.showControls = ParametersHandler.parseBooleanOrDefault(showControlsParam, true);
            allowAppletInteractiveConnections = ParametersHandler.parseBooleanOrDefault(pr.getParamByName(ARG_ALLOW_APPLET_INTERACTIVE_CONNECTIONS), false);
            rfbSettings.setViewOnly(ParametersHandler.parseBooleanOrDefault(viewOnlyParam, false));
            if (ParametersHandler.isGiven(viewOnlyParam)) {
                rfbMask |= 1;
            }
            rfbSettings.setAllowClipboardTransfer(ParametersHandler.parseBooleanOrDefault(allowClipboardTransfer, true));
            if (ParametersHandler.isGiven(allowClipboardTransfer)) {
                rfbMask |= 0x80;
            }
            rfbSettings.setRemoteCharsetName(remoteCharsetName);
            rfbSettings.setAllowCopyRect(ParametersHandler.parseBooleanOrDefault(allowCopyRectParam, true));
            if (ParametersHandler.isGiven(allowCopyRectParam)) {
                rfbMask |= 4;
            }
            rfbSettings.setSharedFlag(ParametersHandler.parseBooleanOrDefault(shareDesktopParam, true));
            if (ParametersHandler.isGiven(shareDesktopParam)) {
                rfbMask |= 0x400;
            }
            rfbSettings.setConvertToAscii(ParametersHandler.parseBooleanOrDefault(convertToAsciiParam, false));
            if (ParametersHandler.isGiven(convertToAsciiParam)) {
                rfbMask |= 0x100;
            }
            if (EncodingType.TIGHT.getName().equalsIgnoreCase(encodingParam)) {
                rfbSettings.setPreferredEncoding(EncodingType.TIGHT);
                rfbMask |= 2;
            }
            if (EncodingType.HEXTILE.getName().equalsIgnoreCase(encodingParam)) {
                rfbSettings.setPreferredEncoding(EncodingType.HEXTILE);
                rfbMask |= 2;
            }
            if (EncodingType.ZRLE.getName().equalsIgnoreCase(encodingParam)) {
                rfbSettings.setPreferredEncoding(EncodingType.ZRLE);
                rfbMask |= 2;
            }
            if (EncodingType.RAW_ENCODING.getName().equalsIgnoreCase(encodingParam)) {
                rfbSettings.setPreferredEncoding(EncodingType.RAW_ENCODING);
                rfbMask |= 2;
            }
            try {
                int compLevel = Integer.parseInt(compressionLevelParam);
                if (compLevel > 0 && compLevel <= 9) {
                    rfbSettings.setCompressionLevel(compLevel);
                    rfbMask |= 0x20;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                int jpegQuality = Integer.parseInt(jpegQualityParam);
                if (jpegQuality > 0 && jpegQuality <= 9) {
                    rfbSettings.setJpegQuality(jpegQuality);
                    rfbMask |= 0x40;
                }
            }
            catch (NumberFormatException e) {
                if (!"lossless".equalsIgnoreCase(jpegQualityParam)) break block27;
                rfbSettings.setJpegQuality(-Math.abs(rfbSettings.getJpegQuality()));
            }
        }
        try {
            int colorDepth = Integer.parseInt(colorDepthParam);
            rfbSettings.setColorDepth(colorDepth);
            rfbMask |= 0x200;
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int uiMask = 0;
        if (scaleFactorParam != null) {
            try {
                int scaleFactor = Integer.parseInt(scaleFactorParam.replaceAll("\\D", ""));
                if (scaleFactor >= 10 && scaleFactor <= 200) {
                    uiSettings.setScalePercent(scaleFactor);
                    uiMask |= 1;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        uiSettings.setFullScreen(ParametersHandler.parseBooleanOrDefault(fullScreenParam, false));
        if (ParametersHandler.isGiven(fullScreenParam)) {
            uiMask |= 4;
        }
        if ("on".equalsIgnoreCase(localPointerParam) || "true".equalsIgnoreCase(localPointerParam) || "yes".equalsIgnoreCase(localPointerParam)) {
            rfbSettings.setMouseCursorTrack(LocalPointer.ON);
            rfbMask |= 0x10;
        }
        if ("off".equalsIgnoreCase(localPointerParam) || "no".equalsIgnoreCase(localPointerParam) || "false".equalsIgnoreCase(localPointerParam)) {
            rfbSettings.setMouseCursorTrack(LocalPointer.OFF);
            rfbMask |= 0x10;
        }
        if ("hide".equalsIgnoreCase(localPointerParam) || "hidden".equalsIgnoreCase(localPointerParam)) {
            rfbSettings.setMouseCursorTrack(LocalPointer.HIDE);
            rfbMask |= 0x10;
        }
        return uiMask << 16 | rfbMask;
    }

    private static boolean isGiven(String param) {
        return !Strings.isTrimmedEmpty(param);
    }

    static boolean parseBooleanOrDefault(String param, boolean defaultValue) {
        return defaultValue ? !"no".equalsIgnoreCase(param) && !"false".equalsIgnoreCase(param) : "yes".equalsIgnoreCase(param) || "true".equalsIgnoreCase(param);
    }

    public static int completeSettingsFromApplet(final JApplet applet, ConnectionParams connectionParams, ProtocolSettings rfbSettings, UiSettings uiSettings) {
        isSeparateFrame = ParametersHandler.parseBooleanOrDefault(applet.getParameter(ARG_OPEN_NEW_WINDOW), true);
        int paramsMask = ParametersHandler.completeSettings(new ParamsRetriever(){

            @Override
            public String getParamByName(String name) {
                return applet.getParameter(name);
            }
        }, connectionParams, rfbSettings, uiSettings);
        if (!allowAppletInteractiveConnections && connectionParams.isHostNameEmpty()) {
            connectionParams.hostName = applet.getCodeBase().getHost();
        }
        return paramsMask;
    }

    static interface ParamsRetriever {
        public String getParamByName(String var1);
    }
}

