/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Graphics;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ProgressBarUI;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JProgressBar
extends JComponent
implements SwingConstants,
Accessible {
    private static final long serialVersionUID = 1980046021813598781L;
    private transient boolean indeterminate;
    protected int orientation;
    protected boolean paintBorder;
    protected BoundedRangeModel model;
    protected String progressString;
    protected boolean paintString;
    protected transient ChangeEvent changeEvent;
    protected ChangeListener changeListener;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public int getValue() {
        return this.model.getValue();
    }

    public void setValue(int value) {
        this.model.setValue(value);
    }

    protected void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (this.paintBorder && border != null) {
            border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException("orientation must be one of VERTICAL or HORIZONTAL");
        }
        if (this.orientation != orientation) {
            int oldOrientation = this.orientation;
            this.orientation = orientation;
            this.firePropertyChange("orientation", oldOrientation, this.orientation);
        }
    }

    public boolean isStringPainted() {
        return this.paintString;
    }

    public void setStringPainted(boolean painted) {
        if (this.paintString != painted) {
            boolean oldPainted = this.paintString;
            this.paintString = painted;
            this.firePropertyChange("stringPainted", oldPainted, this.paintString);
        }
    }

    public String getString() {
        if (this.progressString != null) {
            return this.progressString;
        }
        return "" + (int)(this.getPercentComplete() * 100.0) + '%';
    }

    public void setString(String string) {
        if ((string == null || this.progressString == null) && string != this.progressString || string != null && !string.equals(this.progressString)) {
            String oldString = this.progressString;
            this.progressString = string;
            this.firePropertyChange("string", oldString, this.progressString);
        }
    }

    public double getPercentComplete() {
        if (this.getMaximum() == this.getMinimum()) {
            return 1.0;
        }
        return (double)(this.model.getValue() - this.model.getMinimum()) / (double)(this.model.getMaximum() - this.model.getMinimum());
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean painted) {
        if (painted != this.paintBorder) {
            boolean oldPainted = this.paintBorder;
            this.paintBorder = painted;
            this.firePropertyChange("borderPainted", oldPainted, this.paintBorder);
        }
    }

    public ProgressBarUI getUI() {
        return (ProgressBarUI)this.ui;
    }

    public void setUI(ProgressBarUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((ProgressBarUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "ProgressBarUI";
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            public final void stateChanged(ChangeEvent ce) {
                JProgressBar.this.fireStateChanged();
            }
        };
    }

    public void addChangeListener(ChangeListener listener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JProgressBar.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JProgressBar.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public ChangeListener[] getChangeListeners() {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = JProgressBar.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        return (ChangeListener[])this.listenerList.getListeners(clazz);
    }

    protected void fireStateChanged() {
        Object[] changeListeners = this.listenerList.getListenerList();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        int i = changeListeners.length - 2;
        while (i >= 0) {
            Object object = changeListeners[i];
            Class clazz = class$javax$swing$event$ChangeListener;
            if (clazz == null) {
                clazz = JProgressBar.class("[Ljavax.swing.event.ChangeListener;", false);
            }
            if (object == clazz) {
                ((ChangeListener)changeListeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel model) {
        if (model != this.model) {
            this.model.removeChangeListener(this.changeListener);
            this.model = model;
            this.model.addChangeListener(this.changeListener);
            this.fireStateChanged();
        }
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int minimum) {
        this.model.setMinimum(minimum);
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int maximum) {
        this.model.setMaximum(maximum);
    }

    protected String paramString() {
        return "JProgressBar";
    }

    public void setIndeterminate(boolean newValue) {
        if (this.indeterminate != newValue) {
            boolean olddeter = this.indeterminate;
            this.indeterminate = newValue;
            this.firePropertyChange("indeterminate", olddeter, this.indeterminate);
        }
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJProgressBar();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.indeterminate = false;
        this.orientation = 0;
        this.paintBorder = true;
        this.paintString = false;
    }

    public JProgressBar() {
        this(0, 0, 100);
    }

    public JProgressBar(int orientation) {
        this(orientation, 0, 100);
    }

    public JProgressBar(int minimum, int maximum) {
        this(0, minimum, maximum);
    }

    public JProgressBar(int orientation, int minimum, int maximum) {
        this.this();
        this.model = new DefaultBoundedRangeModel(minimum, 0, minimum, maximum);
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException(orientation + " is not a legal orientation");
        }
        this.setOrientation(orientation);
        this.changeListener = this.createChangeListener();
        this.model.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public JProgressBar(BoundedRangeModel model) {
        this.this();
        this.model = model;
        this.changeListener = this.createChangeListener();
        model.addChangeListener(this.changeListener);
        this.updateUI();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJProgressBar
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -2938130009392721813L;

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_BAR;
        }

        public AccessibleValue getAccessibleValue() {
            return null;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number value0) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }

        protected AccessibleJProgressBar() {
        }
    }
}

