/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.openwire.codec.v4;

import java.io.IOException;
import org.apache.activemq.apollo.openwire.codec.BooleanStream;
import org.apache.activemq.apollo.openwire.codec.OpenWireFormat;
import org.apache.activemq.apollo.openwire.codec.v4.ResponseMarshaller;
import org.apache.activemq.apollo.openwire.command.DataArrayResponse;
import org.apache.activemq.apollo.openwire.command.DataStructure;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;

public class DataArrayResponseMarshaller
extends ResponseMarshaller {
    public byte getDataStructureType() {
        return 33;
    }

    public DataStructure createObject() {
        return new DataArrayResponse();
    }

    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataByteArrayInputStream dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        DataArrayResponse info = (DataArrayResponse)o;
        if (bs.readBoolean()) {
            int size = dataIn.readShort();
            DataStructure[] value = new DataStructure[size];
            for (int i = 0; i < size; ++i) {
                value[i] = this.tightUnmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info.setData(value);
        } else {
            info.setData(null);
        }
    }

    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        DataArrayResponse info = (DataArrayResponse)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        return (rc += this.tightMarshalObjectArray1(wireFormat, info.getData(), bs)) + 0;
    }

    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataByteArrayOutputStream dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        DataArrayResponse info = (DataArrayResponse)o;
        this.tightMarshalObjectArray2(wireFormat, info.getData(), dataOut, bs);
    }

    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataByteArrayInputStream dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        DataArrayResponse info = (DataArrayResponse)o;
        if (dataIn.readBoolean()) {
            int size = dataIn.readShort();
            DataStructure[] value = new DataStructure[size];
            for (int i = 0; i < size; ++i) {
                value[i] = this.looseUnmarsalNestedObject(wireFormat, dataIn);
            }
            info.setData(value);
        } else {
            info.setData(null);
        }
    }

    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataByteArrayOutputStream dataOut) throws IOException {
        DataArrayResponse info = (DataArrayResponse)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalObjectArray(wireFormat, info.getData(), dataOut);
    }
}

