/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.dto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.activemq.apollo.util.DtoModule$;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.annotate.JsonTypeName;
import org.codehaus.jackson.map.jsontype.TypeIdResolver;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApolloTypeIdResolver
implements TypeIdResolver {
    protected final HashMap<Class<?>, String> typeToId = new HashMap();
    protected final HashMap<String, JavaType> idToType = new HashMap();
    private JavaType baseType;

    public void init(JavaType baseType) {
        this.baseType = baseType;
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(baseType.getRawClass());
        classes.addAll(Arrays.asList(DtoModule$.MODULE$.extension_classes()));
        for (Class c : classes) {
            if (!baseType.getRawClass().isAssignableFrom(c)) continue;
            JsonTypeName jsonAnnoation = c.getAnnotation(JsonTypeName.class);
            if (jsonAnnoation != null && jsonAnnoation.value() != null) {
                this.typeToId.put(c, jsonAnnoation.value());
                this.idToType.put(jsonAnnoation.value(), TypeFactory.specialize((JavaType)baseType, (Class)c));
                this.idToType.put(c.getName(), TypeFactory.specialize((JavaType)baseType, (Class)c));
                continue;
            }
            XmlRootElement xmlAnnoation = c.getAnnotation(XmlRootElement.class);
            if (xmlAnnoation == null || xmlAnnoation.name() == null) continue;
            this.typeToId.put(c, xmlAnnoation.name());
            this.idToType.put(xmlAnnoation.name(), TypeFactory.specialize((JavaType)baseType, (Class)c));
            this.idToType.put(c.getName(), TypeFactory.specialize((JavaType)baseType, (Class)c));
        }
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public String idFromValue(Object value) {
        return this.idFromValueAndType(value, value.getClass());
    }

    public String idFromValueAndType(Object value, Class<?> aClass) {
        String rc = this.typeToId.get(aClass);
        if (rc == null) {
            throw new IllegalArgumentException("Invalid sub type: " + aClass + ", of base type: " + this.baseType.getRawClass());
        }
        return rc;
    }

    public JavaType typeFromId(String id) {
        JavaType rc = this.idToType.get(id);
        if (rc == null) {
            throw new IllegalArgumentException("Invalid type id '" + id);
        }
        return rc;
    }
}

