/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.tools.apichecker;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JPackage;
import com.google.gwt.tools.apichecker.ApiClass;
import com.google.gwt.tools.apichecker.ApiContainer;
import com.google.gwt.tools.apichecker.ApiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ApiPackage
implements Comparable<ApiPackage>,
ApiElement {
    private Map<String, ApiClass> apiClasses = new HashMap<String, ApiClass>();
    private final ApiContainer apiContainer;
    private final TreeLogger logger;
    private final String name;
    private final JPackage packageObject;

    ApiPackage(JPackage obj, ApiContainer container) {
        this.packageObject = obj;
        this.apiContainer = container;
        this.logger = container.getLogger();
        this.name = obj.getName();
        this.initialize();
    }

    @Override
    public int compareTo(ApiPackage other) {
        return this.getName().compareTo(other.getName());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ApiPackage)) {
            return false;
        }
        return this.getName().equals(((ApiPackage)o).getName());
    }

    @Override
    public String getRelativeSignature() {
        return this.name;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.name;
    }

    List<JClassType> getAllClasses() {
        ArrayList<JClassType> allClasses = new ArrayList<JClassType>(Arrays.asList(this.packageObject.getTypes()));
        this.logger.log(TreeLogger.SPAM, "API " + this.packageObject + " has " + allClasses.size() + " outer classes", null);
        for (int index = 0; index < allClasses.size(); ++index) {
            JClassType classObject = (JClassType)allClasses.get(index);
            allClasses.addAll(Arrays.asList(classObject.getNestedTypes()));
        }
        this.logger.log(TreeLogger.SPAM, "API " + this.packageObject + " has " + allClasses.size() + " total classes", null);
        return allClasses;
    }

    String getApiAsString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name + ", size = " + this.apiClasses.size() + "\n");
        ArrayList<ApiClass> apiClassesList = new ArrayList<ApiClass>(this.apiClasses.values());
        Collections.sort(apiClassesList);
        for (ApiClass apiClass : apiClassesList) {
            sb.append(apiClass.getApiAsString());
        }
        return sb.toString();
    }

    ApiClass getApiClass(String className) {
        return this.apiClasses.get(className);
    }

    Set<ApiClass> getApiClassesBySet(Set<String> classNames) {
        HashSet<ApiClass> set = new HashSet<ApiClass>();
        for (String className : classNames) {
            set.add(this.getApiClass(className));
        }
        return set;
    }

    Set<String> getApiClassNames() {
        return new HashSet<String>(this.apiClasses.keySet());
    }

    ApiContainer getApiContainer() {
        return this.apiContainer;
    }

    String getName() {
        return this.name;
    }

    private void initialize() {
        ArrayList<String> notAddedClassNames = new ArrayList<String>();
        for (JClassType classType : this.getAllClasses()) {
            if (this.apiContainer.isApiClass(classType)) {
                ApiClass apiClass = new ApiClass(classType, this);
                this.apiClasses.put(classType.getQualifiedSourceName(), apiClass);
                continue;
            }
            notAddedClassNames.add(classType.toString());
        }
        if (notAddedClassNames.size() > 0) {
            this.logger.log(TreeLogger.SPAM, "API " + this.apiContainer.getName() + ", package: " + this.name + ", not adding " + notAddedClassNames.size() + " nonApi classes: " + notAddedClassNames, null);
        }
    }
}

