/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.core.SubexponentialIntegerCodec;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.SliceBlocksReadStreams;
import htsjdk.samtools.cram.structure.SliceBlocksWriteStreams;
import java.nio.ByteBuffer;

public final class SubexponentialIntegerEncoding
extends CRAMEncoding<Integer> {
    private final int offset;
    private final int k;

    SubexponentialIntegerEncoding(int offset, int k) {
        super(EncodingID.SUBEXPONENTIAL);
        if (k < 0) {
            throw new IllegalArgumentException("k parameter must not be negative");
        }
        this.offset = offset;
        this.k = k;
    }

    public static SubexponentialIntegerEncoding fromSerializedEncodingParams(byte[] serializedParams) {
        ByteBuffer buffer = ByteBuffer.wrap(serializedParams);
        int offset = ITF8.readUnsignedITF8(buffer);
        int k = ITF8.readUnsignedITF8(buffer);
        return new SubexponentialIntegerEncoding(offset, k);
    }

    @Override
    public byte[] toSerializedEncodingParams() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        ITF8.writeUnsignedITF8(this.offset, buffer);
        ITF8.writeUnsignedITF8(this.k, buffer);
        buffer.flip();
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes);
        return bytes;
    }

    @Override
    public CRAMCodec<Integer> buildCodec(SliceBlocksReadStreams sliceBlocksReadStreams, SliceBlocksWriteStreams sliceBlocksWriteStreams) {
        return new SubexponentialIntegerCodec(sliceBlocksReadStreams == null ? null : sliceBlocksReadStreams.getCoreBlockInputStream(), sliceBlocksWriteStreams == null ? null : sliceBlocksWriteStreams.getCoreOutputStream(), this.offset, this.k);
    }

    public String toString() {
        return String.format("Offset: %d k: %d", this.offset, this.k);
    }
}

