/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.parsers;

import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.lang.MutableString;
import java.io.IOException;
import java.io.Reader;

public class ReaderFastaParser {
    private FastBufferedReader reader;
    private boolean hasNext;
    private final MutableString line = new MutableString();
    private MutableString previousDescriptionLine = new MutableString();

    public ReaderFastaParser(Reader fastaFileSource) throws IOException {
        this();
        this.setReader(fastaFileSource);
    }

    public ReaderFastaParser() {
    }

    public void setReader(Reader reader) throws IOException {
        this.reader = reader instanceof FastBufferedReader ? (FastBufferedReader)reader : new FastBufferedReader(reader);
        this.hasNext = this.readNextDescriptionLine(this.reader);
    }

    public boolean hasNextSequence() {
        return this.hasNext;
    }

    public boolean nextSequence(MutableString descriptionLine) {
        if (!this.hasNext) {
            return false;
        }
        descriptionLine.replace(this.previousDescriptionLine);
        return true;
    }

    public Reader getBaseReader() {
        return new OneBaseAtATimeReader(this.reader);
    }

    public static void guessAccessionCode(CharSequence descriptionLine, MutableString accessionCode) {
        char c;
        accessionCode.setLength(0);
        int startIndex = descriptionLine.length() > 3 && descriptionLine.charAt(0) == 'P' && descriptionLine.charAt(1) == '1' && descriptionLine.charAt(2) == ';' ? 3 : 0;
        for (int i = startIndex; i < descriptionLine.length() && (c = descriptionLine.charAt(i)) != ' ' && c != '\t' && c != '|'; ++i) {
            accessionCode.append(c);
        }
    }

    private boolean readNextDescriptionLine(FastBufferedReader fastBufferedReader) throws IOException {
        do {
            this.previousDescriptionLine = fastBufferedReader.readLine(this.previousDescriptionLine);
            if (this.previousDescriptionLine != null) continue;
            return false;
        } while (!this.previousDescriptionLine.startsWith(">"));
        this.previousDescriptionLine = this.removeBracket(this.previousDescriptionLine);
        return true;
    }

    private MutableString removeBracket(MutableString descriptionLine) {
        return descriptionLine.substring(1, descriptionLine.length());
    }

    private class OneBaseAtATimeReader
    extends Reader {
        private final FastBufferedReader sequenceReader;

        OneBaseAtATimeReader(FastBufferedReader reader) {
            this.sequenceReader = reader;
        }

        @Override
        public int read() throws IOException {
            int c = this.sequenceReader.read();
            if (c == -1) {
                ReaderFastaParser.this.hasNext = false;
                return -1;
            }
            char character = (char)c;
            if (c == 62) {
                ReaderFastaParser.this.line.setLength(0);
                this.sequenceReader.readLine(ReaderFastaParser.this.line);
                ReaderFastaParser.this.previousDescriptionLine.replace(ReaderFastaParser.this.line);
                ReaderFastaParser.this.hasNext = true;
                return -1;
            }
            return !(c >= 48 && c <= 54 || c >= 65 && c <= 90 || c >= 97 && c <= 122) ? this.read() : c;
        }

        @Override
        public int read(char[] chars, int i, int i1) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

