/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.auth;

import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
public final class StsAssumeRoleWithWebIdentityCredentialsProvider
extends StsCredentialsProvider {
    private final Supplier<AssumeRoleWithWebIdentityRequest> assumeRoleWithWebIdentityRequest;

    private StsAssumeRoleWithWebIdentityCredentialsProvider(Builder builder) {
        super(builder, "sts-assume-role-with-web-identity-credentials-provider");
        Validate.notNull((Object)builder.assumeRoleWithWebIdentityRequestSupplier, (String)"Assume role with web identity request must not be null.", (Object[])new Object[0]);
        this.assumeRoleWithWebIdentityRequest = builder.assumeRoleWithWebIdentityRequestSupplier;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Credentials getUpdatedCredentials(StsClient stsClient) {
        AssumeRoleWithWebIdentityRequest request = this.assumeRoleWithWebIdentityRequest.get();
        Validate.notNull((Object)((Object)request), (String)"AssumeRoleWithWebIdentityRequest can't be null", (Object[])new Object[0]);
        return stsClient.assumeRoleWithWebIdentity(request).credentials();
    }

    public String toString() {
        return ToString.builder((String)"StsAssumeRoleWithWebIdentityCredentialsProvider").add("refreshRequest", this.assumeRoleWithWebIdentityRequest).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends StsCredentialsProvider.BaseBuilder<Builder, StsAssumeRoleWithWebIdentityCredentialsProvider> {
        private Supplier<AssumeRoleWithWebIdentityRequest> assumeRoleWithWebIdentityRequestSupplier;

        private Builder() {
            super((B x$0) -> new StsAssumeRoleWithWebIdentityCredentialsProvider((Builder)x$0));
        }

        public Builder refreshRequest(AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) {
            return this.refreshRequest(() -> assumeRoleWithWebIdentityRequest);
        }

        public Builder refreshRequest(Supplier<AssumeRoleWithWebIdentityRequest> assumeRoleWithWebIdentityRequest) {
            this.assumeRoleWithWebIdentityRequestSupplier = assumeRoleWithWebIdentityRequest;
            return this;
        }

        public Builder refreshRequest(Consumer<AssumeRoleWithWebIdentityRequest.Builder> assumeRoleWithWebIdentityRequest) {
            return this.refreshRequest((AssumeRoleWithWebIdentityRequest)((Object)((AssumeRoleWithWebIdentityRequest.Builder)AssumeRoleWithWebIdentityRequest.builder().applyMutation(assumeRoleWithWebIdentityRequest)).build()));
        }

        @Override
        public StsAssumeRoleWithWebIdentityCredentialsProvider build() {
            return (StsAssumeRoleWithWebIdentityCredentialsProvider)super.build();
        }
    }
}

