/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.html2;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.html2.DomHTMLDocument;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLOptionsCollection;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

class DomHTMLCollection
implements HTMLCollection,
HTMLOptionsCollection,
NodeList,
NodeFilter {
    final DomHTMLDocument doc;
    final Node root;
    List nodeNames;
    List attributeNames;
    List results;

    void addNodeName(String string) {
        if (this.nodeNames == null) {
            this.nodeNames = new LinkedList();
        }
        this.nodeNames.add(string);
    }

    void addAttributeName(String string) {
        if (this.attributeNames == null) {
            this.attributeNames = new LinkedList();
        }
        this.attributeNames.add(string);
    }

    public short acceptNode(Node node2) {
        if (node2.getNodeType() != 1) {
            return 3;
        }
        String string = node2.getLocalName();
        if (string == null) {
            string = node2.getNodeName();
        }
        if (this.nodeNames != null && !this.acceptName(string)) {
            return 3;
        }
        if (this.attributeNames != null && !this.acceptAttributes(node2.getAttributes())) {
            return 3;
        }
        return 1;
    }

    private final boolean acceptName(String string) {
        Iterator iterator = this.nodeNames.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private final boolean acceptAttributes(NamedNodeMap namedNodeMap) {
        Iterator iterator = this.attributeNames.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            Node node2 = this.getNamedItem(namedNodeMap, string2);
            if (node2 == null || (string = node2.getNodeValue()) == null || string.length() <= 0) continue;
            return true;
        }
        return false;
    }

    private final Node getNamedItem(NamedNodeMap namedNodeMap, String string) {
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = namedNodeMap.item(n2);
            String string2 = node2.getLocalName();
            if (string2 == null) {
                string2 = node2.getNodeName();
            }
            if (string.equalsIgnoreCase(string2)) {
                return node2;
            }
            ++n2;
        }
        return null;
    }

    void evaluate() {
        NodeIterator nodeIterator = this.doc.createNodeIterator(this.root, 1, this, true);
        this.results = new ArrayList();
        Node node2 = nodeIterator.nextNode();
        while (node2 != null) {
            this.results.add(node2);
            node2 = nodeIterator.nextNode();
        }
    }

    public int getLength() {
        return this.results.size();
    }

    public void setLength(int n) {
        throw new DomDOMException(9);
    }

    public Node item(int n) {
        return (Node)this.results.get(n);
    }

    public Node namedItem(String string) {
        boolean bl = false;
        Iterator iterator = this.results.iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            NamedNodeMap namedNodeMap = node2.getAttributes();
            Node node3 = this.getNamedItem(namedNodeMap, "id");
            if (string.equals(node3.getTextContent())) {
                return node2;
            }
            if (bl || !string.equals((node3 = this.getNamedItem(namedNodeMap, "name")).getTextContent())) continue;
            return node2;
        }
        return null;
    }

    DomHTMLCollection(DomHTMLDocument domHTMLDocument, Node node2) {
        this.doc = domHTMLDocument;
        this.root = node2;
    }
}

