/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class MetalSliderUI
extends BasicSliderUI {
    protected static Color thumbColor;
    protected static Color highlightColor;
    protected static Color darkShadowColor;
    protected static int trackWidth;
    protected static int tickLength;
    protected static Icon horizThumbIcon;
    protected static Icon vertThumbIcon;
    protected final int TICK_BUFFER = 4;
    protected final String SLIDER_FILL = "JSlider.isFilled";
    protected boolean filledSlider;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalSliderUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        Boolean bl = (Boolean)jComponent.getClientProperty("JSlider.isFilled");
        if (bl != null) {
            this.filledSlider = bl;
        }
    }

    protected PropertyChangeListener createPropertyChangeListener(JSlider jSlider) {
        return new MetalPropertyListener();
    }

    public void paintThumb(Graphics graphics) {
        if (this.slider.getOrientation() == 0) {
            horizThumbIcon.paintIcon(this.slider, graphics, this.thumbRect.x, this.thumbRect.y);
        } else {
            vertThumbIcon.paintIcon(this.slider, graphics, this.thumbRect.x, this.thumbRect.y);
        }
    }

    public void paintTrack(Graphics graphics) {
        ColorUIResource colorUIResource = MetalLookAndFeel.getControlShadow();
        if (this.slider.getOrientation() == 0) {
            int n = this.trackRect.x;
            int n2 = this.trackRect.y + (this.trackRect.height - this.getTrackWidth()) / 2;
            int n3 = this.trackRect.width - 1;
            int n4 = this.getTrackWidth();
            if (this.slider.isEnabled()) {
                BasicGraphicsUtils.drawEtchedRect(graphics, n, n2, n3, n4, darkShadowColor, colorUIResource, darkShadowColor, highlightColor);
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawRect(n, n2, n3 - 2, n4 - 2);
            }
            if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
                if (this.slider.isEnabled()) {
                    int n5 = this.xPositionForValue(this.slider.getValue());
                    int n6 = this.slider.getInverted() ? n5 : this.trackRect.x;
                    int n7 = this.slider.getInverted() ? n + n3 - n5 : n5 - this.trackRect.x;
                    graphics.setColor(MetalLookAndFeel.getWhite());
                    graphics.drawLine(n6 + 1, n2 + 1, n6 + n7 - 3, n2 + 1);
                    graphics.setColor(UIManager.getColor("Slider.altTrackColor"));
                    graphics.drawLine(n6 + 1, n2 + 2, n6 + n7 - 3, n2 + 2);
                    graphics.setColor(MetalLookAndFeel.getControlShadow());
                    graphics.drawLine(n6 + 1, n2 + 3, n6 + n7 - 3, n2 + 3);
                    graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
                    graphics.drawLine(n6 + 1, n2 + 4, n6 + n7 - 3, n2 + 4);
                }
            } else if (this.filledSlider) {
                int n8 = this.xPositionForValue(this.slider.getValue());
                int n9 = this.slider.getInverted() ? n8 : this.trackRect.x;
                int n10 = this.slider.getInverted() ? n + n3 - n8 : n8 - this.trackRect.x;
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.fillRect(n9 + 1, n2 + 1, n10 - 3, this.getTrackWidth() - 3);
                if (this.slider.isEnabled()) {
                    graphics.setColor(MetalLookAndFeel.getControl());
                    graphics.drawLine(n9 + 1, n2 + 1, n9 + n10 - 3, n2 + 1);
                    graphics.drawLine(n9 + 1, n2 + 1, n9 + 1, n2 + this.getTrackWidth() - 3);
                }
            }
        } else {
            int n = this.trackRect.x + (this.trackRect.width - this.getTrackWidth()) / 2;
            int n11 = this.trackRect.y;
            int n12 = this.getTrackWidth();
            int n13 = this.trackRect.height - 1;
            if (this.slider.isEnabled()) {
                BasicGraphicsUtils.drawEtchedRect(graphics, n, n11, n12, n13, darkShadowColor, colorUIResource, darkShadowColor, highlightColor);
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawRect(n, n11, n12 - 2, n13 - 2);
            }
            if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
                if (this.slider.isEnabled()) {
                    int n14 = this.yPositionForValue(this.slider.getValue());
                    int n15 = this.slider.getInverted() ? n11 : n14;
                    int n16 = this.slider.getInverted() ? n14 - n11 : n11 + n13 - n14;
                    graphics.setColor(MetalLookAndFeel.getWhite());
                    graphics.drawLine(n + 1, n15 + 1, n + 1, n15 + n16 - 3);
                    graphics.setColor(UIManager.getColor("Slider.altTrackColor"));
                    graphics.drawLine(n + 2, n15 + 1, n + 2, n15 + n16 - 3);
                    graphics.setColor(MetalLookAndFeel.getControlShadow());
                    graphics.drawLine(n + 3, n15 + 1, n + 3, n15 + n16 - 3);
                    graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
                    graphics.drawLine(n + 4, n15 + 1, n + 4, n15 + n16 - 3);
                }
            } else if (this.filledSlider) {
                int n17 = this.yPositionForValue(this.slider.getValue());
                int n18 = this.slider.getInverted() ? n11 : n17;
                int n19 = this.slider.getInverted() ? n17 - n11 : n11 + n13 - n17;
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.fillRect(n + 1, n18 + 1, this.getTrackWidth() - 3, n19 - 3);
                if (this.slider.isEnabled()) {
                    graphics.setColor(MetalLookAndFeel.getControl());
                    graphics.drawLine(n + 1, n18 + 1, n + n12 - 3, n18 + 1);
                    graphics.drawLine(n + 1, n18 + 1, n + 1, n18 + n19 - 3);
                }
            }
        }
    }

    public void paintFocus(Graphics graphics) {
    }

    protected Dimension getThumbSize() {
        if (this.slider.getOrientation() == 0) {
            return new Dimension(horizThumbIcon.getIconWidth(), horizThumbIcon.getIconHeight());
        }
        return new Dimension(vertThumbIcon.getIconWidth(), vertThumbIcon.getIconHeight());
    }

    public int getTickLength() {
        return tickLength + 4;
    }

    protected int getTrackWidth() {
        return trackWidth;
    }

    protected int getTrackLength() {
        return this.slider.getOrientation() == 0 ? this.tickRect.width : this.tickRect.height;
    }

    protected int getThumbOverhang() {
        return 0;
    }

    protected void scrollDueToClickInTrack(int n) {
        super.scrollDueToClickInTrack(n);
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        if (this.slider.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
        } else {
            graphics.setColor(MetalLookAndFeel.getControlDisabled());
        }
        graphics.drawLine(n, 4, n, 4 + tickLength / 2);
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        if (this.slider.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
        } else {
            graphics.setColor(MetalLookAndFeel.getControlDisabled());
        }
        graphics.drawLine(n, 4, n, 4 + tickLength);
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        if (this.slider.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
        } else {
            graphics.setColor(MetalLookAndFeel.getControlDisabled());
        }
        graphics.drawLine(3, n, 3 + tickLength / 2, n);
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        if (this.slider.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
        } else {
            graphics.setColor(MetalLookAndFeel.getControlDisabled());
        }
        graphics.drawLine(3, n, 3 + tickLength, n);
    }

    public MetalSliderUI() {
        super(null);
        this.filledSlider = UIManager.getBoolean("JSlider.isFilled");
        darkShadowColor = MetalLookAndFeel.getControlDarkShadow();
        highlightColor = MetalLookAndFeel.getControlHighlight();
    }

    static {
        trackWidth = UIManager.getInt("Slider.trackWidth");
        tickLength = UIManager.getInt("Slider.majorTickLength");
        horizThumbIcon = UIManager.getIcon("Slider.horizontalThumbIcon");
        vertThumbIcon = UIManager.getIcon("Slider.verticalThumbIcon");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class MetalPropertyListener
    extends BasicSliderUI.PropertyChangeHandler {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("JSlider.isFilled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                MetalSliderUI.this.filledSlider = bl == null ? false : bl;
            } else {
                super.propertyChange(propertyChangeEvent);
            }
        }

        protected MetalPropertyListener() {
        }
    }
}

