# Copyright (C) 2008 LottaNZB Development Team
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

"""Contains classes for all messages put out by the PostProcessorUtil module."""

from lottanzb.hellalog import LogRecord, _Plural, _FatalErrorHandler, _ExceptionHandler
from lottanzb.util import _

class DecompressingArchiveFinishedInfo(_Plural, LogRecord): # processRars(...)
    PATTERN = r"^(?P<archive_name>.+): Finished unraring \((?P<file_count>\d+) rar groups?, took: (?P<elapsed_time>.+)\)$"
    TEMPLATE = _("%(archive_name)s: Finished extracting of %(file_count)s RAR archive in %(elapsed_time)s")
    TEMPLATE_2 = _("%(archive_name)s: Finished extracting of %(file_count)s RAR archives in %(elapsed_time)s")

class UnraringInfo(LogRecord): # unrar(...)
    PATTERN = r"^(?P<archive_name>.+): Unraring (?P<file_name>.+)..$"
    TEMPLATE = _("%(archive_name)s: Unraring %(file_name)s...")

class SkippingParProcessingInfo(LogRecord): # processPars(...)
    PATTERN = r"^(?P<archive_name>.+): Skipping par processing$"
    TEMPLATE = _("%(archive_name)s: Skipping PAR processing")

class ParVerificationFinishedInfo(_Plural, LogRecord): # processRars(...)
    PATTERN = r"^(?P<archive_name>.+): Finished par verify \((?P<file_count>\d+) par groups?, took: (?P<elapsed_time>.+)\)$"
    TEMPLATE = _("%(archive_name)s: Finished PAR verification of %(file_count)s PAR group in %(elapsed_time)s")
    TEMPLATE_2 = _("%(archive_name)s: Finished PAR verification of %(file_count)s PAR groups in %(elapsed_time)s")

class ParVerifyingInfo(LogRecord): # processPars(...)
    PATTERN = r"^(?P<archive_name>.+): Verifying via par group: (?P<wildcard>.+)\.\.$"
    TEMPLATE = _("%(archive_name)s: Verifying via PAR group: %(wildcard)s...")

class AssemblingSplitFilesInfo(LogRecord): # assembleSplitFiles(...)
    PATTERN = r"^(?P<archive_name>.+): Assembling split file from parts: (?P<key>.+)\.\*\.\.$"
    TEMPLATE = _("%(archive_name)s: Assembling split file from parts: %(key)s.*...")

class AssemblingTSFilesInfo(AssemblingSplitFilesInfo): # assembleSplitFiles(...)
    PATTERN = r"^(?P<archive_name>.+): Assembling split TS file from parts: (?P<key>.+)\.\*\.ts\.\.$"
    TEMPLATE = _("%(archive_name)s: Assembling split TS file from parts: %(key)s.*.ts...")

class ConvertingMacBinaryInfo(LogRecord): # decodeMacBin(...)
    PATTERN = r"^(?P<archive_name>.+): Converting MacBinary files\.\.$"
    TEMPLATE = _("%(archive_name)s: Converting MacBinary files...")

class ConvertingMacBinaryFinishedInfo(_Plural, LogRecord): # decodeMacBin(...)
    PATTERN = r"^(?P<archive_name>.+): Finished converting MacBinary files \((?P<file_count>\d+) files?, took: (?P<elapsed_time>.+)\)$"
    TEMPLATE = _("%(archive_name)s: Finished converting %(file_count)s MacBinary file in %(elapsed_time)s")
    TEMPLATE_2 = _("%(archive_name)s: Finished converting %(file_count)s MacBinary files in %(elapsed_time)s")

class RenamedWarning(LogRecord): # unrar(...)
    PATTERN = r"^(?P<archive_name>.+): Renamed (?P<original>.+) to (?P<renamed>.+) \(rar: (?P<file_name>.+) has the same file\)$"
    TEMPLATE = _("%(archive_name)s: Renamed %(original)s to %(renamed)s. %(file_name)s has the same file")

class DecompressionError(_FatalErrorHandler, LogRecord): # DecompressionThread.run()
    PATTERN = r"^(?P<archive_name>.+)"
    TEMPLATE = "%(archive_name)s"

class UnhandledDecompressionError(_ExceptionHandler, LogRecord): # DecompressionThread.run()
    PATTERN = r"^(?P<archive_name>.+): There was an unexpected problem while decompressing the music file: (?P<file_name>.+)"
    TEMPLATE = _("%(archive_name)s: There was an unexpected problem while decompressing the music file %(file_name)s")

class DefineMusicTypeError(LogRecord): # defineMusicType()
    PATTERN = r"^Problem in config file with defineMusicType() for extension: (?P<extension>.*)$"
    TEMPLATE = _("Problem in configuration file with defineMusicType() for extension: %(extension)s")

class DecompressingMusicFileFatal(LogRecord): # decompressMusicFile(...)
    PATTERN = r"^There was a problem while decompressing music file: (?P<file_name>.+) output:\n(?P<output>.+)\z"
    TEMPLATE = _("There was a problem while decompressing music file %(file_name)s. Output:\n%(output)s")

class RARPasswordRequiredFatal(LogRecord): # unrar(...)
    PATTERN = r"^Cannot continue, this archive requires a RAR password. Run (?P<command>.+) -p on the archive directory with the -P option to specify a password$"
    TEMPLATE = _("This RAR archive requires a password.")

class RARListingFatal(LogRecord): # unrar(...)
    PATTERN = r"^There was a problem during the rar listing, output:\n(?P<output>.+)\z$"
    TEMPLATE = _("There was a problem during the RAR listing. Output:\n%(output)s")

class UnrarFatal(LogRecord): # unrar(...)
    PATTERN = r"^There was a problem during unrar, output:\n\n(?P<output>.+)\z"
    TEMPLATE = _("There was a problem during unrar. Output:\n%(output)s")

class BadArchiveFatal(LogRecord): # par2(...)
    PATTERN = r"^Unable to par repair: archive requires (?P<needed_blocks>/d+) more recovery (?P<recovery_name>.*) for repair\. No valid files found (bad archive?)$"
    TEMPLATE = _("Unable to 'par repair': Archive requires %(needed_blocks)s more recovery %(recovery_name)s for repair. No valid files found (bad archive?)")
    
class ParRepairFatal(LogRecord): # par2(...)
    PATTERN = r"^Unable to par repair: archive requires (?P<needed_blocks>/d+) more recovery (?P<recovery_name>.*) for repair$"
    TEMPLATE = _("Unable to 'par repair': Archive requires %(needed_blocks)s more recovery %(recovery_name)s for repair")

class UnhandledParRepairFatal(LogRecord): # par2(...)
    PATTERN = r"^Unable to par repair: archive requires (?P<needed_blocks>/d+) more recovery (?P<recovery_name>.*) for repair$"
    TEMPLATE = _("Unable to 'par repair': Archive requires %(needed_blocks)s more recovery %(recovery_name)s for repair")

class MoreRecoveryNeededWarning(LogRecord): # par2(...)
    PATTERN = r"^par2 repair failed: returned code: (?P<return_code>.+)\. Please run par2 manually for more information, par2 cmd: (?P<command>.+)$"
    TEMPLATE = _("'par2 repair' failed with error code %(return_code)s. Please run par2 manually for more information, par2 cmd: %(command)s")

# Todo
class DiskFullFatal(LogRecord): # assembleSplitFiles(...)
    PATTERN = r"^Ran out of disk space while assembling split (?P<type_name>.+): (?P<key>.+)$"
    TEMPLATE = _("Ran out of disk space while assembling split %(type_name)s: %(key)s")

class MacBinaryFatal(LogRecord): # decodeMacBin(...)
    PATTERN = r"^There was a problem during MacBinary file conversion, output:\n\n(?P<output>.+)\z"
    TEMPLATE = _("There was a problem during MacBinary file conversion. Output:\n%(output)s")

# Todo: parseParNeedsBlocksOutput(...)
