/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner.plugin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.parosproxy.paros.core.scanner.AbstractAppPlugin;
import org.parosproxy.paros.network.HttpMessage;

public class TestClientAutocomplete
extends AbstractAppPlugin {
    public static final Pattern patternAutocomplete = Pattern.compile("AUTOCOMPLETE\\s*=[^>]*OFF[^>]*", 10);
    public static final Pattern patternForm = Pattern.compile("(<FORM\\s*[^>]+\\s*>)(.*?)</FORM>", 42);
    public static final Pattern patternInput = Pattern.compile("(<INPUT\\s*[^>]+type=[\"']?PASSWORD[\"']?[^>]+\\s*>)", 42);

    public int getId() {
        return 10001;
    }

    public String getName() {
        return "Password Autocomplete in browser";
    }

    public String[] getDependency() {
        return null;
    }

    public String getDescription() {
        return "AUTOCOMPLETE attribute is not disabled in HTML FORM/INPUT element containing password type input.  Passwords may be stored in browsers and retrieved.";
    }

    public int getCategory() {
        return 1;
    }

    public String getSolution() {
        String string = "Turn off AUTOCOMPLETE attribute in form or individual input elements containing password by using AUTOCOMPLETE='OFF'";
        return string;
    }

    public String getReference() {
        return "http://msdn.microsoft.com/library/default.asp?url=/workshop/author/forms/autocomplete_ovr.asp";
    }

    public void init() {
    }

    public void scan() {
        HttpMessage httpMessage = this.getBaseMsg();
        String string = httpMessage.getResponseBody().toString();
        String string2 = null;
        String string3 = null;
        Matcher matcher = patternForm.matcher(string);
        Matcher matcher2 = null;
        Matcher matcher3 = null;
        while (matcher.find()) {
            string2 = matcher.group(1);
            string3 = matcher.group(2);
            if (string2 == null || string3 == null || !this.isExistPasswordInput(string3) || (matcher2 = patternAutocomplete.matcher(string2)).find()) continue;
            matcher3 = patternInput.matcher(string3);
            while (matcher3.find()) {
                String string4 = matcher3.group(1);
                if (string4 == null || (matcher2 = patternAutocomplete.matcher(string4)).find()) continue;
                this.bingo(2, 1, null, "", string4, httpMessage);
            }
        }
    }

    private boolean isExistPasswordInput(String string) {
        Matcher matcher = patternInput.matcher(string);
        return matcher.find();
    }
}

