/*
 * Decompiled with CFR 0.152.
 */
package beagleutil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ThreadSafeIndexer<T> {
    public static final int DEFAULT_INIT_CAPACITY = 500;
    private final List<T> list;
    private final Map<T, Integer> map;

    public ThreadSafeIndexer() {
        this(500);
    }

    public ThreadSafeIndexer(int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.list = new ArrayList<T>(n);
        this.map = new HashMap<T, Integer>(n);
    }

    public synchronized int getIndex(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.map.keySet().contains(t)) {
            return this.map.get(t);
        }
        int n = this.list.size();
        this.list.add(t);
        this.map.put(t, n);
        return n;
    }

    public synchronized int[] getIndices(T[] TArray) {
        int[] nArray = new int[TArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            T t = TArray[i];
            if (t == null) {
                throw new NullPointerException();
            }
            if (this.map.keySet().contains(t)) {
                nArray[i] = this.map.get(t);
                continue;
            }
            int n = this.list.size();
            this.list.add(t);
            this.map.put(t, n);
            nArray[i] = n;
        }
        return nArray;
    }

    public synchronized int getIndexIfIndexed(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.map.keySet().contains(t)) {
            return this.map.get(t);
        }
        return -1;
    }

    public synchronized int size() {
        return this.list.size();
    }

    public synchronized T item(int n) {
        return this.list.get(n);
    }

    public synchronized List<T> items(int[] nArray) {
        ArrayList<T> arrayList = new ArrayList<T>(nArray.length);
        for (int n : nArray) {
            arrayList.add(this.list.get(n));
        }
        return arrayList;
    }

    public synchronized List<T> items() {
        return new ArrayList<T>(this.list);
    }

    public synchronized String toString() {
        return this.items().toString();
    }
}

