/*
 * Decompiled with CFR 0.152.
 */
package free.jin.board;

import free.jin.Connection;
import free.jin.Game;
import free.jin.I18n;
import free.jin.event.GameAdapter;
import free.jin.event.GameEndEvent;
import free.jin.event.GameListener;
import free.jin.event.OfferEvent;
import free.jin.plugin.Plugin;
import free.jin.ui.OptionPanel;
import free.util.TableLayout;
import free.util.swing.SwingUtils;
import free.workarounds.FixedJPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class PlayedGameButtonPanel
extends FixedJPanel
implements ActionListener {
    protected static final int OFFERED_STATE = 0;
    protected static final int OFFER_STATE = 1;
    protected static final int CLAIM_STATE = 2;
    protected static final int ACCEPT_STATE = 3;
    private static final int STATE_BORDER_SIZE = 5;
    private static final Border OFFERED_STATE_BORDER = new EmptyBorder(5, 5, 5, 5);
    private static final Border OFFER_STATE_BORDER = new EmptyBorder(5, 5, 5, 5);
    private static final Border CLAIM_STATE_BORDER = new LineBorder(Color.orange, 5);
    private static final Border ACCEPT_STATE_BORDER = new LineBorder(Color.green.darker(), 5);
    protected final Plugin plugin;
    protected final Game game;
    protected final Component parentComponent;
    protected JButton resignButton;
    private JPanel resignButtonPanel;
    protected JButton drawButton;
    private JPanel drawButtonPanel;
    protected JButton abortButton;
    private JPanel abortButtonPanel;
    protected JButton adjournButton;
    private JPanel adjournButtonPanel;
    protected JButton takeback1Button;
    private JPanel takeback1ButtonPanel;
    protected JButton takebackNButton;
    private JPanel takebackNButtonPanel;
    private GameListener gameListener = new GameAdapter(){

        public void offerUpdated(OfferEvent offerEvent) {
            if (offerEvent.getGame() != PlayedGameButtonPanel.this.game) {
                return;
            }
            boolean bl = offerEvent.getPlayer().equals(PlayedGameButtonPanel.this.game.getUserPlayer().getOpponent());
            switch (offerEvent.getOfferId()) {
                case 1: {
                    PlayedGameButtonPanel.this.drawOfferUpdate(bl, offerEvent.isOffered());
                    break;
                }
                case 3: {
                    PlayedGameButtonPanel.this.abortOfferUpdate(bl, offerEvent.isOffered());
                    break;
                }
                case 2: {
                    PlayedGameButtonPanel.this.adjournOfferUpdate(bl, offerEvent.isOffered());
                    break;
                }
                case 4: {
                    PlayedGameButtonPanel.this.takebackOfferUpdate(bl, offerEvent.isOffered(), offerEvent.getTakebackCount());
                }
            }
            super.offerUpdated(offerEvent);
        }

        public void gameEnded(GameEndEvent gameEndEvent) {
            if (gameEndEvent.getGame() != PlayedGameButtonPanel.this.game) {
                return;
            }
            PlayedGameButtonPanel.this.drawButton.setEnabled(false);
            PlayedGameButtonPanel.this.resignButton.setEnabled(false);
            if (PlayedGameButtonPanel.this.abortButton != null) {
                PlayedGameButtonPanel.this.abortButton.setEnabled(false);
            }
            if (PlayedGameButtonPanel.this.adjournButton != null) {
                PlayedGameButtonPanel.this.adjournButton.setEnabled(false);
            }
            if (PlayedGameButtonPanel.this.takeback1Button != null) {
                PlayedGameButtonPanel.this.takeback1Button.setEnabled(false);
            }
            if (PlayedGameButtonPanel.this.takebackNButton != null) {
                PlayedGameButtonPanel.this.takebackNButton.setEnabled(false);
            }
            PlayedGameButtonPanel.this.plugin.getConn().getListenerManager().removeGameListener((GameListener)this);
            super.gameEnded(gameEndEvent);
        }
    };
    private final Vector userTakebacks = new Vector();
    private final Vector oppTakebacks = new Vector();

    public PlayedGameButtonPanel(Plugin plugin, Game game, Component component) {
        this.plugin = plugin;
        this.game = game;
        this.parentComponent = component;
        this.init(plugin, game);
    }

    protected void init(Plugin plugin, Game game) {
        this.createComponents(plugin, game);
        this.addComponents(plugin, game);
        this.setDrawState(1);
        this.setAbortState(1);
        this.setAdjournState(1);
        this.setResignState(2);
        this.setTakeback1State(1);
        this.setTakebackNState(1, 2);
        plugin.getConn().getListenerManager().addGameListener(this.gameListener);
    }

    protected void drawOfferUpdate(boolean bl, boolean bl2) {
        this.setDrawState(bl2 ? (bl ? 3 : 0) : 1);
    }

    protected void abortOfferUpdate(boolean bl, boolean bl2) {
        this.setAbortState(bl2 ? (bl ? 3 : 0) : 1);
    }

    protected void adjournOfferUpdate(boolean bl, boolean bl2) {
        this.setAdjournState(bl2 ? (bl ? 3 : 0) : 1);
    }

    protected void takebackOfferUpdate(boolean bl, boolean bl2, int n) {
        int n2;
        int n3;
        Vector vector;
        Vector vector2 = vector = bl ? this.oppTakebacks : this.userTakebacks;
        if (bl2) {
            vector.addElement(new Integer(n));
        } else {
            vector.removeElement(new Integer(n));
        }
        if (this.oppTakebacks.isEmpty()) {
            if (this.userTakebacks.isEmpty()) {
                n3 = 1;
                n2 = n;
            } else {
                Integer n4 = (Integer)this.userTakebacks.elementAt(this.userTakebacks.size() - 1);
                n3 = 0;
                n2 = n4;
            }
        } else {
            Integer n5 = (Integer)this.oppTakebacks.elementAt(this.oppTakebacks.size() - 1);
            n3 = 3;
            n2 = n5;
        }
        if (n2 == 1) {
            this.setTakeback1State(n3);
        } else {
            this.setTakebackNState(n3, n3 == 1 ? 2 : n2);
        }
    }

    protected void createComponents(Plugin plugin, Game game) {
        Connection connection = plugin.getConn();
        this.resignButton = this.createButton("resignButton");
        this.drawButton = this.createButton("drawButton");
        this.abortButton = connection.isAbortSupported() ? this.createButton("abortButton") : null;
        this.adjournButton = connection.isAdjournSupported() ? this.createButton("adjournButton") : null;
        this.takeback1Button = connection.isTakebackSupported() ? this.createButton("takebackButton") : null;
        this.takebackNButton = connection.isMultipleTakebackSupported() ? this.createButton("multipleTakebackButton") : null;
    }

    private JButton createButton(String string) {
        I18n i18n = I18n.get((Class)PlayedGameButtonPanel.class);
        JButton jButton = i18n.createButton(string);
        jButton.addActionListener(this);
        jButton.setDefaultCapable(false);
        jButton.setRequestFocusEnabled(false);
        Font font = UIManager.getFont("Button.font");
        int n = Math.max(14, font.getSize());
        jButton.setFont(new Font(font.getFamily(), 1, n));
        return jButton;
    }

    protected void setDrawState(int n) {
        I18n i18n = I18n.get((Class)PlayedGameButtonPanel.class);
        this.drawButton.setEnabled(n != 0);
        switch (n) {
            case 0: {
                this.drawButtonPanel.setBorder(OFFERED_STATE_BORDER);
                break;
            }
            case 1: {
                this.drawButton.setToolTipText(i18n.getString("drawButton.offerTooltip"));
                this.drawButtonPanel.setBorder(OFFER_STATE_BORDER);
                break;
            }
            case 2: {
                this.drawButton.setToolTipText(i18n.getString("drawButton.claimTooltip"));
                this.drawButtonPanel.setBorder(CLAIM_STATE_BORDER);
                break;
            }
            case 3: {
                this.drawButton.setToolTipText(i18n.getString("drawButton.acceptTooltip"));
                this.drawButtonPanel.setBorder(ACCEPT_STATE_BORDER);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized state: " + n);
            }
        }
    }

    protected void setAbortState(int n) {
        if (this.abortButton == null) {
            return;
        }
        I18n i18n = I18n.get((Class)PlayedGameButtonPanel.class);
        this.abortButton.setEnabled(n != 0);
        switch (n) {
            case 0: {
                this.abortButtonPanel.setBorder(OFFERED_STATE_BORDER);
                break;
            }
            case 1: {
                this.abortButton.setToolTipText(i18n.getString("abortButton.offerTooltip"));
                this.abortButtonPanel.setBorder(OFFER_STATE_BORDER);
                break;
            }
            case 2: {
                this.abortButton.setToolTipText(i18n.getString("abortButton.claimTooltip"));
                this.abortButtonPanel.setBorder(CLAIM_STATE_BORDER);
                break;
            }
            case 3: {
                this.abortButton.setToolTipText(i18n.getString("abortButton.acceptTooltip"));
                this.abortButtonPanel.setBorder(ACCEPT_STATE_BORDER);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized state: " + n);
            }
        }
    }

    protected void setAdjournState(int n) {
        if (this.adjournButton == null) {
            return;
        }
        I18n i18n = I18n.get((Class)PlayedGameButtonPanel.class);
        this.adjournButton.setEnabled(n != 0);
        switch (n) {
            case 0: {
                this.adjournButtonPanel.setBorder(OFFERED_STATE_BORDER);
                break;
            }
            case 1: {
                this.adjournButton.setToolTipText(i18n.getString("adjournButton.offerTooltip"));
                this.adjournButtonPanel.setBorder(OFFER_STATE_BORDER);
                break;
            }
            case 2: {
                this.adjournButton.setToolTipText(i18n.getString("adjournButton.claimTooltip"));
                this.adjournButtonPanel.setBorder(CLAIM_STATE_BORDER);
                break;
            }
            case 3: {
                this.adjournButton.setToolTipText(i18n.getString("adjournButton.acceptTooltip"));
                this.adjournButtonPanel.setBorder(ACCEPT_STATE_BORDER);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized state: " + n);
            }
        }
    }

    protected void setTakeback1State(int n) {
        if (this.takeback1Button == null) {
            return;
        }
        I18n i18n = I18n.get((Class)PlayedGameButtonPanel.class);
        this.takeback1Button.setEnabled(n != 0);
        switch (n) {
            case 0: {
                this.takeback1ButtonPanel.setBorder(OFFERED_STATE_BORDER);
                break;
            }
            case 1: {
                this.takeback1Button.setToolTipText(i18n.getString("takebackButton.offerTooltip"));
                this.takeback1ButtonPanel.setBorder(OFFER_STATE_BORDER);
                break;
            }
            case 2: {
                this.takeback1Button.setToolTipText(i18n.getString("takebackButton.claimTooltip"));
                this.takeback1ButtonPanel.setBorder(CLAIM_STATE_BORDER);
                break;
            }
            case 3: {
                this.takeback1Button.setToolTipText(i18n.getString("takebackButton.acceptTooltip"));
                this.takeback1ButtonPanel.setBorder(ACCEPT_STATE_BORDER);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized state: " + n);
            }
        }
    }

    protected void setTakebackNState(int n, int n2) {
        if (this.takebackNButton == null) {
            return;
        }
        I18n i18n = I18n.get((Class)PlayedGameButtonPanel.class);
        Object[] objectArray = new Object[]{new Integer(n2)};
        String string = i18n.getFormattedString("multipleTakebackButton.text", objectArray);
        SwingUtils.applyLabelSpec((AbstractButton)this.takebackNButton, (String)string);
        this.takebackNButton.setEnabled(n != 0);
        this.takebackNButton.setActionCommand(String.valueOf(n2));
        switch (n) {
            case 0: {
                this.takebackNButtonPanel.setBorder(OFFERED_STATE_BORDER);
                break;
            }
            case 1: {
                this.takebackNButton.setToolTipText(i18n.getFormattedString("multipleTakebackButton.offerTooltip", objectArray));
                this.takebackNButtonPanel.setBorder(OFFER_STATE_BORDER);
                break;
            }
            case 2: {
                this.takebackNButton.setToolTipText(i18n.getFormattedString("multipleTakebackButton.claimTooltip", objectArray));
                this.takebackNButtonPanel.setBorder(CLAIM_STATE_BORDER);
                break;
            }
            case 3: {
                this.takebackNButton.setToolTipText(i18n.getFormattedString("multipleTakebackButton.claimTooltip", objectArray));
                this.takebackNButtonPanel.setBorder(ACCEPT_STATE_BORDER);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized state: " + n);
            }
        }
    }

    protected void setResignState(int n) {
        switch (n) {
            case 1: {
                throw new IllegalArgumentException("The resign button may only be in claim state");
            }
            case 2: {
                this.resignButtonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
                break;
            }
            case 3: {
                throw new IllegalArgumentException("The resign button may only be in claim state");
            }
            default: {
                throw new IllegalArgumentException("Unrecognized state: " + n);
            }
        }
    }

    protected void addComponents(Plugin plugin, Game game) {
        this.setLayout((LayoutManager)new TableLayout(2, 5, 5));
        this.drawButtonPanel = new JPanel(new BorderLayout());
        this.drawButtonPanel.add((Component)this.drawButton, "Center");
        this.add(this.drawButtonPanel);
        this.resignButtonPanel = new JPanel(new BorderLayout());
        this.resignButtonPanel.add((Component)this.resignButton, "Center");
        this.add(this.resignButtonPanel);
        if (this.abortButton != null) {
            this.abortButtonPanel = new JPanel(new BorderLayout());
            this.abortButtonPanel.add((Component)this.abortButton, "Center");
            this.add(this.abortButtonPanel);
        }
        if (this.adjournButton != null) {
            this.adjournButtonPanel = new JPanel(new BorderLayout());
            this.adjournButtonPanel.add((Component)this.adjournButton, "Center");
            this.add(this.adjournButtonPanel);
        }
        if (this.takeback1Button != null) {
            this.takeback1ButtonPanel = new JPanel(new BorderLayout());
            this.takeback1ButtonPanel.add((Component)this.takeback1Button, "Center");
            this.add(this.takeback1ButtonPanel);
        }
        if (this.takebackNButton != null) {
            this.takebackNButtonPanel = new JPanel(new BorderLayout());
            this.takebackNButtonPanel.add((Component)this.takebackNButton, "Center");
            this.add(this.takebackNButtonPanel);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        Connection connection = this.plugin.getConn();
        if (object == this.resignButton) {
            Object object2 = I18n.get((Class)PlayedGameButtonPanel.class).confirm(OptionPanel.OK, "resignConfirmation", this.parentComponent);
            if (object2 == OptionPanel.OK) {
                connection.resign(this.game);
            }
        } else if (object == this.drawButton) {
            connection.requestDraw(this.game);
        } else if (object == this.abortButton) {
            connection.requestAbort(this.game);
        } else if (object == this.adjournButton) {
            connection.requestAdjourn(this.game);
        } else if (object == this.takeback1Button) {
            connection.requestTakeback(this.game);
        } else if (object == this.takebackNButton) {
            int n = Integer.parseInt(this.takebackNButton.getActionCommand());
            connection.requestTakeback(this.game, n);
        }
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

