/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PROPERTY_DIALOG_H__
#define __SG_PROPERTY_DIALOG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define SG_PROPERTY_DIALOG(obj)        GTK_CHECK_CAST (obj, sg_property_dialog_get_type (), SGpropertyDialog)
#define GTK_TYPE_SG_PROPERTY_DIALOG   (sg_property_dialog_get_type ())

#define SG_PROPERTY_DIALOG_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_property_dialog_get_type(), SGpropertyDialogClass)
#define GTK_IS_SG_PROPERTY_DIALOG(obj)     GTK_CHECK_TYPE (obj, sg_property_dialog_get_type ())


typedef struct _SGpropertyDialog SGpropertyDialog;
typedef struct _SGpropertyDialogClass SGpropertyDialogClass;

struct _SGpropertyDialog
{
  GtkFrame frame;

  GtkWidget *ok_button;
  GtkWidget *apply_button;
  GtkWidget *cancel_button;
  gpointer data;
  gboolean destroy_data;

  void (*apply)         (SGpropertyDialog *app, gpointer data);
  void (*ok)         	(SGpropertyDialog *app, gpointer data);
  void (*cancel)        (SGpropertyDialog *app, gpointer data);
};

struct _SGpropertyDialogClass
{
  GtkFrameClass parent_class;
};

GtkType 	sg_property_dialog_get_type		(void);
GtkWidget *	sg_property_dialog_new			(void);
void		sg_property_dialog_set_buttons		(SGpropertyDialog *d,
							 GtkWidget *ok_button,
							 GtkWidget *apply_button,
							 GtkWidget *cancel_button);
void		sg_property_dialog_set_data		(SGpropertyDialog *dialog,
							 gpointer data,
							 gboolean destroy_data);
void		sg_property_dialog_apply		(SGpropertyDialog *d);
void		sg_property_dialog_ok			(SGpropertyDialog *d);
void		sg_property_dialog_cancel		(SGpropertyDialog *d);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_PROPERTY_DIALOG_H__ */
