<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Monitoring\Resource;

use Google\Service\Monitoring\ListSnoozesResponse;
use Google\Service\Monitoring\Snooze;

/**
 * The "snoozes" collection of methods.
 * Typical usage is:
 *  <code>
 *   $monitoringService = new Google\Service\Monitoring(...);
 *   $snoozes = $monitoringService->projects_snoozes;
 *  </code>
 */
class ProjectsSnoozes extends \Google\Service\Resource
{
  /**
   * Creates a Snooze that will prevent alerts, which match the provided criteria,
   * from being opened. The Snooze applies for a specific time interval.
   * (snoozes.create)
   *
   * @param string $parent Required. The project
   * (https://cloud.google.com/monitoring/api/v3#project_name) in which a Snooze
   * should be created. The format is: projects/[PROJECT_ID_OR_NUMBER]
   * @param Snooze $postBody
   * @param array $optParams Optional parameters.
   * @return Snooze
   * @throws \Google\Service\Exception
   */
  public function create($parent, Snooze $postBody, $optParams = [])
  {
    $params = ['parent' => $parent, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('create', [$params], Snooze::class);
  }
  /**
   * Retrieves a Snooze by name. (snoozes.get)
   *
   * @param string $name Required. The ID of the Snooze to retrieve. The format
   * is: projects/[PROJECT_ID_OR_NUMBER]/snoozes/[SNOOZE_ID]
   * @param array $optParams Optional parameters.
   * @return Snooze
   * @throws \Google\Service\Exception
   */
  public function get($name, $optParams = [])
  {
    $params = ['name' => $name];
    $params = array_merge($params, $optParams);
    return $this->call('get', [$params], Snooze::class);
  }
  /**
   * Lists the Snoozes associated with a project. Can optionally pass in filter,
   * which specifies predicates to match Snoozes. (snoozes.listProjectsSnoozes)
   *
   * @param string $parent Required. The project
   * (https://cloud.google.com/monitoring/api/v3#project_name) whose Snoozes
   * should be listed. The format is: projects/[PROJECT_ID_OR_NUMBER]
   * @param array $optParams Optional parameters.
   *
   * @opt_param string filter Optional. Optional filter to restrict results to the
   * given criteria. The following fields are supported. interval.start_time
   * interval.end_timeFor example: ``` interval.start_time >
   * "2022-03-11T00:00:00-08:00" AND interval.end_time <
   * "2022-03-12T00:00:00-08:00" ```
   * @opt_param int pageSize Optional. The maximum number of results to return for
   * a single query. The server may further constrain the maximum number of
   * results returned in a single page. The value should be in the range 1, 1000.
   * If the value given is outside this range, the server will decide the number
   * of results to be returned.
   * @opt_param string pageToken Optional. The next_page_token from a previous
   * call to ListSnoozesRequest to get the next page of results.
   * @return ListSnoozesResponse
   * @throws \Google\Service\Exception
   */
  public function listProjectsSnoozes($parent, $optParams = [])
  {
    $params = ['parent' => $parent];
    $params = array_merge($params, $optParams);
    return $this->call('list', [$params], ListSnoozesResponse::class);
  }
  /**
   * Updates a Snooze, identified by its name, with the parameters in the given
   * Snooze object. (snoozes.patch)
   *
   * @param string $name Required. The name of the Snooze. The format is:
   * projects/[PROJECT_ID_OR_NUMBER]/snoozes/[SNOOZE_ID] The ID of the Snooze will
   * be generated by the system.
   * @param Snooze $postBody
   * @param array $optParams Optional parameters.
   *
   * @opt_param string updateMask Required. The fields to update.For each field
   * listed in update_mask: If the Snooze object supplied in the
   * UpdateSnoozeRequest has a value for that field, the value of the field in the
   * existing Snooze will be set to the value of the field in the supplied Snooze.
   * If the field does not have a value in the supplied Snooze, the field in the
   * existing Snooze is set to its default value.Fields not listed retain their
   * existing value.The following are the field names that are accepted in
   * update_mask: display_name interval.start_time interval.end_timeThat said, the
   * start time and end time of the Snooze determines which fields can legally be
   * updated. Before attempting an update, users should consult the documentation
   * for UpdateSnoozeRequest, which talks about which fields can be updated.
   * @return Snooze
   * @throws \Google\Service\Exception
   */
  public function patch($name, Snooze $postBody, $optParams = [])
  {
    $params = ['name' => $name, 'postBody' => $postBody];
    $params = array_merge($params, $optParams);
    return $this->call('patch', [$params], Snooze::class);
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ProjectsSnoozes::class, 'Google_Service_Monitoring_Resource_ProjectsSnoozes');
