/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class MaskFilter
extends RGBImageFilter {
    private Color _newColor;
    private Color _oldColor;
    private static MaskFilter _maskFilter = null;

    public static MaskFilter getInstance(Color oldColor, Color newColor) {
        if (_maskFilter == null) {
            _maskFilter = new MaskFilter(oldColor, newColor);
        } else {
            _maskFilter.setOldColor(oldColor);
            _maskFilter.setNewColor(newColor);
        }
        return _maskFilter;
    }

    private void setNewColor(Color newColor) {
        this._newColor = newColor;
    }

    private void setOldColor(Color oldColor) {
        this._oldColor = oldColor;
    }

    public static Image createImage(Image i, Color oldColor, Color newColor) {
        MaskFilter filter = MaskFilter.getInstance(oldColor, newColor);
        FilteredImageSource prod = new FilteredImageSource(i.getSource(), filter);
        Image image = Toolkit.getDefaultToolkit().createImage(prod);
        return image;
    }

    public static Image createNegativeImage(Image i) {
        return MaskFilter.createImage(i, Color.black, Color.white);
    }

    public MaskFilter(Color oldColor, Color newColor) {
        this._newColor = newColor;
        this._oldColor = oldColor;
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int x, int y, int rgb) {
        if (this._newColor != null && this._oldColor != null && rgb == this._oldColor.getRGB()) {
            return this._newColor.getRGB();
        }
        return rgb;
    }
}

