.\"
.\" $Id: tclgdbm.n,v 1.2 2001/02/10 05:07:40 ellson Exp $
.\"
.so man.macros
.\"
.TH tclgdbm n
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tclgdbm::gdbm \- Access GDBM database files
.SH SYNOPSIS
\fBtclgdbm::gdbm\fR \fIoption\fR \fR?\fIargs\fR?
.BE

.SH DESCRIPTION
.PP
This command gives access to GNU GDBM database files. They provide a
persistent mapping from keys to values. Both
keys and values can contain any arbitrary character. \fIoption\fR specifies
the particular operation on a database. The valid options are:
.TP
\fBtclgdbm::gdbm open \fIfileName \fR?\fIaccessMode\fR? 
Opens a GDBM database file \fIfileName\fR and returns an identifier
\fIdb\fR for further access to the opened database. Optionally an
access mode may be specified. Valid access modes are:
.RS
.TP 
\fBr\fR
Open the database for reading only; the file must already
exist. A database may be opened several times for reading. This mode
is the default if no \fIaccessMode\fR is given.
.TP 
\fBrw\fR 
Open the database for read and write access; the file must already
exist. 
.TP 
\fBrwc\fR 
Open the database for read and write access; create a new database if
none exists.
.TP 
\fBrwn\fR
Create a new database and allow further read and write
access. An existing database named \fIfileName\fR will be overwritten!
.LP
.RE
.TP
\fBtclgdbm::gdbm close\fR \fIdb\fR
Close the database referred to by \fIdb\fR. Returns nothing.
.RE
.TP
\fBtclgdbm::gdbm insert\fR \fIdb\fR \fIkey\fR \fIvalue\fR ?\fIvalue\fR?  
Insert the \fIkey\fR,\fIvalue\fR ?\fIvalue\fR? pair into the database
referred to by \fIdb\fR.
When more than one \fIvalue\fR is given, a
list of them is built and that list is stored.
If \fIkey\fR is already
a key in \fIdb\fR an error will be reported and the database is left
unchanged. \fIdb\fR must be opened for write access. Nothing is
returned.
.RE
.TP
\fBtclgdbm::gdbm store\fR \fIdb\fR \fIkey\fR \fIvalue\fR ?\fIvalue\fR?  
Insert the \fIkey\fR,\fIvalue\fR pair into the database referred to by
\fIdb\fR.
When more than one \fIvalue\fR is given, a
list of them is built and that list is stored.
If \fIkey\fR is already a key in
\fIdb\fR then \fIvalue\fR ?\fIvalue\fR? will replaces the old value
if write mode has been set to \fBGDBM_REPLACE\fR, otherwise
an error will be reported and the database is left
unchanged.
\fIdb\fR must be opened for write access. Nothing
is returned.
.RE
.TP
\fBtclgdbm::gdbm delete\fR \fIdb\fR \fIkey\fR
Delete the \fIkey\fR and the associated value from the database referred
to by \fIdb\fR. \fIdb\fR must be opened for write access. Nothing is returned.
.RE
.TP
\fBtclgdbm::gdbm error\fR \fBnumber\fR|\fBtext\fR
Return the value of the last GDBM error as either a number or a text string.
.RE
.TP
\fBtclgdbm::gdbm exists\fR \fIdb\fR \fIkey\fR
Check for existence of \fIkey\fR in database referred to by \fIdb\fR. Returns
\fB1\fR if \fIkey\fR exists, \fB0\fR otherwise.
.RE
.TP
\fBtclgdbm::gdbm fetch\fR \fIdb\fR \fIkey\fR
Retrieve the associated value to \fIkey\fR from database referred to by
\fIdb\fR and return it. The command fails if \fIkey\fR does not exist in
\fIdb\fR. 
.RE
.TP 
\fBtclgdbm::gdbm list\fR \fIdb\fR 
Return a list (unsorted) of all keys in the database referred to by
\fIdb\fR.
.RE
.TP 
\fBtclgdbm::gdbm firstkey\fR \fIdb\fR, \fBtclgdbm::gdbm nextkey\fR \fIdb\fR \fIkey\fR
These two commands provide a first/next scheme to retrieve all keys
from a database \fIdb\fR. \fBtclgdbm::gdbm firstkey\fR returns a starting key \fIk\fR; a
subsequent call to \fBtclgdbm::gdbm nextkey\fR \fIk\fR returns the next key. If there
exists no next key, an empty string is returned.
.RE
.TP 
\fBtclgdbm::gdbm reorganize\fR \fIdb\fR
Reorganize the database file referred to by \fIdb\fR. If you have had a
lot of deletions and would like to shrink the space used by the
database file, this routine will reorganize the database.  Gdbm will
not shorten the length of a gdbm file except by using this
reorganization.  Deleted file space will be reused. This command
should be used very infrequently. \fIdb\fR must be opened for write
access.
.RE
.TP
\fBtclgdbm::gdbm writemode\fR \fIdb\fR \fBreplace\fR|\fBinsert\fR
Set the default write mode for the database referred to by \fIdb\fR
to
\fBGDBM_REPLACE\fR or \fBGDBM_INSERT\fR.
Defaults to \fBGDBM_REPLACE\fR for backwards
compatibility.
Subsequent \fBtclgdbm::gdbm store\fR commands will use this write mode.

.SH AUTHOR
Christian Lindig <lindig@ips.cs.tu-bs.de>, TU Braunschweig, Institut
fuer Programmiersprachen, Abteilung Softwaretechnologie, D-38106
Braunschweig, Germany.

John Ellson <ellson@lucent.com> with additions by H.-Juergen Godau (JG)
<godau@wi-inf.uni-essen.de>

Dave Bodenstab <imdave@mcs.net> completely reworked the source converting
it to use Tcl_Obj's and incorporating version 0.4 of
Christian Lindig's tcl+gdbm.

.SH SEE ALSO
gdbm(3)
