/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.eip.cayenne.om.portlet.EipTTodo;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.screens.ALVelocityScreen;
import com.aimluck.eip.msgboard.MsgboardTopicSelectData;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MsgboardTopicScreen
extends ALVelocityScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MsgboardTopicScreen.class.getName());

    protected void doOutput(RunData rundata, Context context) throws Exception {
        VelocityPortlet portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
        String mode = rundata.getParameters().getString("mode");
        try {
            if ("update".equals(mode)) {
                this.updateState(rundata, context, portlet);
            }
            context.put("ajax_onloadimage", (Object)"true");
            ParameterParser parser = rundata.getParameters();
            ALEipUtils.passPSML((RunData)rundata, (Context)context, (String)"p12f-filters", (String)parser.getString("filter"));
            ALEipUtils.passPSML((RunData)rundata, (Context)context, (String)"p12g-filtertypes", (String)parser.getString("filtertype"));
            MsgboardTopicSelectData listData = new MsgboardTopicSelectData();
            listData.initField();
            listData.loadCategoryList(rundata, context);
            listData.setRowsNum(Integer.parseInt(portlet.getPortletConfig().getInitParameter("p1a-rows")));
            listData.setTableColumNum(Integer.parseInt(portlet.getPortletConfig().getInitParameter("p1e-rows")));
            listData.doViewList((ALAction)this, rundata, context);
            String layout_template = "portlets/html/ja/ajax-msgboard-topic.vm";
            this.setTemplate(rundata, context, layout_template);
        }
        catch (Exception ex) {
            logger.error((Object)"[MsgboardTopicScreen] Exception.", (Throwable)ex);
            ALEipUtils.redirectDBError((RunData)rundata);
        }
    }

    protected void updateState(RunData rundata, Context context, VelocityPortlet portlet) {
        boolean isValid;
        ArrayList msgList = new ArrayList();
        ALNumberField state = new ALNumberField();
        state.setFieldName(ALLocalizationUtils.getl10n((String)"MSGBOARD_STATUS"));
        state.limitValue(0L, 100L);
        state.setNotNull(true);
        if (!rundata.getParameters().containsKey((Object)"state")) {
            return;
        }
        state.setValue(rundata.getParameters().getString("state"));
        ALNumberField eid = new ALNumberField();
        state.setFieldName("entity id");
        eid.setNotNull(true);
        if (!rundata.getParameters().containsKey((Object)"entityid")) {
            return;
        }
        eid.setValue(rundata.getParameters().getString("entityid"));
        int value = (int)state.getValue();
        boolean bl = isValid = value % 10 == 0 && state.validate(msgList) && eid.validate(msgList);
        if (!isValid) {
            return;
        }
        try {
            SelectQuery query = Database.query(EipTTodo.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchDbExp((String)"TODO_ID", (Object)((int)eid.getValue()));
            query.andQualifier(exp2);
            List list = query.fetchList();
            if (list == null || list.size() == 0) {
                return;
            }
            EipTTodo todo = (EipTTodo)list.get(0);
            todo.setState(Short.valueOf((short)value));
            Database.commit();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"[MsgboardTopicScreen]", (Throwable)ex);
            return;
        }
    }

    protected String getPortletName() {
        return "Msgboard";
    }
}

