/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.msgboard;

import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.msgboard.MsgboardTopicSelectData;
import com.aimluck.eip.msgboard.util.MsgboardUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MsgboardCategoryMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MsgboardCategoryMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            SelectQuery<EipTMsgboardCategory> query = this.getSelectQuery(rundata, values);
            List list = query.fetchList();
            if (list == null || list.size() == 0) {
                logger.debug((Object)"[MsgboardMultiDelete] Empty CategoryIDs...");
                return false;
            }
            for (EipTMsgboardCategory category : list) {
                List topics = category.getEipTMsgboardTopics();
                for (EipTMsgboardTopic topic : topics) {
                    MsgboardUtils.deleteAttachmentFiles(topic);
                }
                Database.delete((Persistent)category);
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(category.getCategoryId().intValue(), 181, category.getCategoryName());
            }
            Database.commit();
            String filtername = MsgboardTopicSelectData.class.getName() + "filter";
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)filtername);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"msgboard", (Throwable)ex);
            return false;
        }
        return true;
    }

    private SelectQuery<EipTMsgboardCategory> getSelectQuery(RunData rundata, List<String> values) {
        SelectQuery query = Database.query(EipTMsgboardCategory.class);
        Expression exp = ExpressionFactory.inDbExp((String)"CATEGORY_ID", values);
        query.setQualifier(exp);
        return query;
    }

    protected int getDefineAclType() {
        return 16;
    }

    public String getAclPortletFeature() {
        return "msgboard_category";
    }
}

