/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.addressbook.AddressBookGroupResultData;
import com.aimluck.eip.addressbook.util.AddressBookUtils;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressGroup;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookGroupSelectData
extends ALAbstractSelectData<EipMAddressGroup, EipMAddressGroup> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookGroupSelectData.class.getName());
    private List<AddressBookGroupResultData> groupList;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"group_name");
        }
        this.groupList = AddressBookUtils.getMyGroups(rundata);
        super.init(action, rundata, context);
    }

    protected ResultList<EipMAddressGroup> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<EipMAddressGroup> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            return query.getResultList();
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookGroupSelectData.selectList", (Throwable)ex);
            return null;
        }
    }

    protected EipMAddressGroup selectDetail(RunData rundata, Context context) {
        return AddressBookUtils.getEipMAddressGroup(rundata, context);
    }

    protected Object getResultData(EipMAddressGroup record) {
        try {
            AddressBookGroupResultData rd = new AddressBookGroupResultData();
            rd.initField();
            rd.setGroupId(record.getGroupId().longValue());
            rd.setGroupName(record.getGroupName());
            rd.setPublicFlag(record.getPublicFlag());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"AddressBookGroupSelectData.getResultData", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(EipMAddressGroup obj) {
        return this.getResultData(obj);
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("group_name", "groupName");
        return map;
    }

    private SelectQuery<EipMAddressGroup> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipMAddressGroup.class);
        Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
        query.setQualifier(exp);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    public List<ALStringField> getGroupMemberList(String gid) {
        return AddressBookUtils.getGroupMember(gid);
    }

    public String getAclPortletFeature() {
        return "addressbook_company_group";
    }

    public List<AddressBookGroupResultData> getGroupList() {
        return this.groupList;
    }
}

