/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl;

import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.TreeCache;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Cache
implements TreeCache {
    private final Map<String, Tree> primary;
    private final Map<String, Tree> secondary;

    public Cache(int size) {
        this(size, new WeakHashMap<String, Tree>());
    }

    public Cache(final int size, Map<String, Tree> secondary) {
        this.primary = Collections.synchronizedMap(new LinkedHashMap<String, Tree>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Tree> eldest) {
                if (this.size() > size) {
                    if (Cache.this.secondary != null) {
                        Cache.this.secondary.put(eldest.getKey(), eldest.getValue());
                    }
                    return true;
                }
                return false;
            }
        });
        this.secondary = secondary == null ? null : Collections.synchronizedMap(secondary);
    }

    @Override
    public Tree get(String expression) {
        if (this.secondary == null) {
            return this.primary.get(expression);
        }
        Tree tree = this.primary.get(expression);
        if (tree == null) {
            tree = this.secondary.get(expression);
        }
        return tree;
    }

    @Override
    public void put(String expression, Tree tree) {
        this.primary.put(expression, tree);
    }
}

