/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.system;

import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.system.SystemNetworkResultData;
import com.aimluck.eip.system.util.SystemUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALServletUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class SystemNetworkSelectData
extends ALAbstractSelectData<EipMCompany, EipMCompany> {
    private static final String SAMPLE_USER1 = "sample1";
    private static final String SAMPLE_USER2 = "sample2";
    private static final String SAMPLE_USER3 = "sample3";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)SystemNetworkSelectData.class.getName());

    protected ResultList<EipMCompany> selectList(RunData rundata, Context context) {
        return null;
    }

    protected EipMCompany selectDetail(RunData rundata, Context context) {
        return SystemUtils.getEipMCompany(rundata, context);
    }

    protected Object getResultData(EipMCompany record) {
        return null;
    }

    protected Object getResultDataDetail(EipMCompany record) {
        SystemNetworkResultData rd = new SystemNetworkResultData();
        rd.initField();
        try {
            Integer port_internal;
            Enumeration<NetworkInterface> enuIfs;
            String ipaddress = record.getIpaddressInternal();
            if ((null == ipaddress || "".equals(ipaddress)) && null != (enuIfs = NetworkInterface.getNetworkInterfaces())) {
                while (enuIfs.hasMoreElements()) {
                    NetworkInterface ni = enuIfs.nextElement();
                    Enumeration<InetAddress> enuAddrs = ni.getInetAddresses();
                    while (enuAddrs.hasMoreElements()) {
                        InetAddress in4 = enuAddrs.nextElement();
                        if (in4.isLoopbackAddress()) continue;
                        ipaddress = in4.getHostAddress();
                    }
                }
            }
            if (null == (port_internal = record.getPortInternal())) {
                port_internal = 80;
            }
            String localurl = ALServletUtils.getAccessUrl((String)ipaddress, (int)port_internal, (boolean)false);
            String globalurl = ALServletUtils.getAccessUrl((String)record.getIpaddress(), (int)record.getPort(), (boolean)true);
            rd.setLocalUrl(localurl);
            rd.setGlobalUrl(globalurl);
            try {
                Object[] sampleName = new String[]{SAMPLE_USER1, SAMPLE_USER2, SAMPLE_USER3};
                Object[] sampleId = new String[]{"4", "5", "6"};
                SelectQuery query = Database.query(TurbineUser.class);
                Expression exp1 = ExpressionFactory.inExp((String)"loginName", (Object[])sampleName);
                Expression exp2 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
                Expression exp3 = ExpressionFactory.inDbExp((String)"USER_ID", (Object[])sampleId);
                query.setQualifier(exp1.andExp(exp2).andExp(exp3));
                List list = ALEipUtils.getUsersFromSelectQuery((SelectQuery)query);
                if (list.size() <= 0) {
                    rd.setSample("");
                } else {
                    rd.setSample("exist");
                }
            }
            catch (Exception ex) {
                logger.error((Object)"system", (Throwable)ex);
                rd.setSample("exist");
                return null;
            }
        }
        catch (SocketException e) {
            logger.error((Object)"[SystemNetworkSelectData]", (Throwable)e);
        }
        return rd;
    }

    protected Attributes getColumnMap() {
        return null;
    }
}

