/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.system;

import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.ALMailReceiverContext;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.actions.system.SystemManagerAction;
import com.aimluck.eip.modules.screens.SystemWebMailAdminFormScreen;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.system.SystemWebMailAccountDetailResultData;
import com.aimluck.eip.system.SystemWebMailAccountResultData;
import com.aimluck.eip.system.SystemWebMailFolderResultData;
import com.aimluck.eip.system.util.SystemWebMailUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class SystemWebMailAccountSelectData
extends ALAbstractSelectData<EipMMailAccount, EipMMailAccount> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)SystemWebMailAccountSelectData.class.getName());
    private String orgId;
    private boolean isAdmin;
    private int accountId = -1;
    private Map<Integer, Integer> unreadMailSumMap;
    private List<SystemWebMailFolderResultData> mailFolderList;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.orgId = Database.getDomainName();
        try {
            this.accountId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"accountid"));
        }
        catch (Exception e) {
            this.accountId = 0;
        }
        int userId = ALEipUtils.getUserId((RunData)rundata);
        if (this.accountId == 0) {
            try {
                Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)userId);
                SelectQuery query = Database.query(EipMMailAccount.class, (Expression)exp);
                query.select("ACCOUNT_ID");
                List accounts = query.fetchList();
                if (accounts == null || accounts.size() <= 0) {
                    return;
                }
                EipMMailAccount account = (EipMMailAccount)accounts.get(0);
                this.accountId = account.getAccountId();
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"accountid", (String)Integer.toString(this.accountId));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.isAdmin = rundata.getScreen().equals(SystemWebMailAdminFormScreen.class.getSimpleName()) || action.getClass().getName().equals(SystemManagerAction.class.getName());
        this.unreadMailSumMap = SystemWebMailUtils.getUnreadMailNumberMap(rundata, userId, this.accountId);
        this.mailFolderList = SystemWebMailUtils.getMailFolderAll(ALMailUtils.getMailAccount((int)userId, (int)this.accountId));
        super.init(action, rundata, context);
    }

    protected ResultList<EipMMailAccount> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<EipMMailAccount> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            return query.getResultList();
        }
        catch (Exception ex) {
            logger.error((Object)"system", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipMMailAccount> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipMMailAccount.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
        Expression exp2 = ExpressionFactory.noMatchExp((String)"accountType", (Object)2);
        return query.setQualifier(exp1.andExp(exp2));
    }

    protected EipMMailAccount selectDetail(RunData rundata, Context context) {
        int userId = ALEipUtils.getUserId((RunData)rundata);
        EipMMailAccount account = null;
        if (this.isAdmin) {
            account = ALMailUtils.getEipMMailAccountForAdmin();
        } else {
            int accountId = rundata.getParameters().getInt("accountid", -1);
            account = ALMailUtils.getMailAccount((int)userId, (int)accountId);
        }
        return account;
    }

    protected Object getResultData(EipMMailAccount record) {
        try {
            SystemWebMailAccountResultData rd = new SystemWebMailAccountResultData();
            rd.initField();
            rd.setAccountId(record.getAccountId());
            rd.setAccountName(record.getAccountName());
            rd.setMailAddress(record.getMailAddress());
            ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
            ALMailReceiverContext rcontext = ALMailUtils.getALPop3MailReceiverContext((String)this.orgId, (EipMMailAccount)record);
            rd.setCountUnRead(handler.getUnReadMailSum(rcontext));
            Date finalAccessDate = record.getLastReceivedDate();
            rd.setFinalAccessDate(ALMailUtils.translateDate((Date)finalAccessDate));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"system", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(EipMMailAccount record) {
        try {
            SystemWebMailAccountDetailResultData rd = new SystemWebMailAccountDetailResultData();
            rd.initField();
            rd.setAccountId(record.getAccountId());
            rd.setAccountName(record.getAccountName());
            rd.setSmtpserverName(record.getSmtpserverName());
            rd.setPop3serverName(record.getPop3serverName());
            rd.setPop3userName(record.getPop3userName());
            rd.setPop3Password("******");
            rd.setMailUserName(record.getMailUserName());
            rd.setMailAddress(record.getMailAddress());
            rd.setSmtpPort(Integer.parseInt(record.getSmtpPort()));
            rd.setPop3Port(Integer.parseInt(record.getPop3Port()));
            rd.setAuthSendFlg(Short.valueOf(record.getAuthSendFlg()).shortValue());
            rd.setAuthSendUserId(record.getAuthSendUserId());
            rd.setAuthSendUserPassword("******");
            rd.setSignature(record.getSignature());
            rd.setPop3EncryptionFlag(record.getPop3EncryptionFlg().shortValue());
            rd.setSmtpEncryptionFlag(record.getSmtpEncryptionFlg().shortValue());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"system", (Throwable)ex);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("account_name", "accountName");
        return map;
    }

    public int getUnReadMailSumByFolderId(int folder_id) {
        return this.unreadMailSumMap.get(folder_id);
    }

    public List<SystemWebMailFolderResultData> getFolderList() {
        return this.mailFolderList;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }
}

