/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.config.impl;

import com.aimluck.eip.cayenne.om.account.EipMConfig;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.services.config.ALConfigHandler;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class ALDefaultConfigHanlder
extends ALConfigHandler {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALDefaultConfigHanlder.class.getName());
    private static ALConfigHandler instance;

    public static ALConfigHandler getInstance() {
        if (instance == null) {
            instance = new ALDefaultConfigHanlder();
        }
        return instance;
    }

    public String get(ALConfigHandler.Property property) {
        return this.get(property.toString(), property.defaultValue());
    }

    public void put(ALConfigHandler.Property property, String value) {
        this.put(property.toString(), value);
    }

    public String get(String property, String defaultValue) {
        EipMConfig config = null;
        try {
            Object obj = ALEipManager.getInstance().getConfig(property.toString());
            if (obj != null) {
                return (String)obj;
            }
            config = (EipMConfig)Database.query(EipMConfig.class).where(Operations.eq((String)"name", (Object)property.toString())).fetchSingle();
            if (config == null) {
                ALEipManager.getInstance().setConfig(property.toString(), (Object)defaultValue);
            } else {
                ALEipManager.getInstance().setConfig(property.toString(), (Object)config.getValue());
            }
        }
        catch (CayenneRuntimeException e) {
            throw e;
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (config == null) {
            return defaultValue;
        }
        return config.getValue();
    }

    public void put(String property, String value) {
        try {
            EipMConfig config = (EipMConfig)Database.query(EipMConfig.class).where(Operations.eq((String)"name", (Object)property)).fetchSingle();
            if (config == null) {
                config = (EipMConfig)Database.create(EipMConfig.class);
                config.setName(property.toString());
            }
            config.setValue(value);
            Database.commit();
        }
        catch (Throwable t) {
            Database.rollback();
            if (t instanceof CayenneRuntimeException) {
                throw (CayenneRuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }
}

