/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.cache;

import java.lang.ref.SoftReference;
import java.util.Hashtable;
import ojb.broker.Identity;
import ojb.broker.cache.ObjectCache;
import ojb.broker.metadata.ClassNotPersistenceCapableException;
import ojb.broker.util.Logger;
import ojb.broker.util.LoggerFactory;

public class ObjectCacheDefaultImpl
implements ObjectCache {
    protected Hashtable objectTable = new Hashtable();
    private long hitCount = 0L;
    private long failCount = 0L;
    private long gcCount = 0L;

    public void cache(Object obj) throws ClassNotPersistenceCapableException {
        Identity oid = new Identity(obj);
        this.cache(oid, obj);
    }

    public void clear() {
        this.objectTable.clear();
    }

    public void cache(Identity oid, Object obj) {
        if (obj != null) {
            SoftReference<Object> ref = new SoftReference<Object>(obj);
            this.objectTable.put(oid.toString(), ref);
        }
    }

    public Object lookup(Identity oid) {
        ++this.hitCount;
        Object obj = null;
        SoftReference ref = (SoftReference)this.objectTable.get(oid.toString());
        if (ref != null) {
            obj = ref.get();
            if (obj == null) {
                ++this.gcCount;
                this.objectTable.remove(oid);
            }
        } else {
            ++this.failCount;
        }
        return obj;
    }

    public void remove(Object obj) {
        if (obj != null) {
            String oidString = null;
            oidString = obj instanceof Identity ? obj.toString() : new Identity(obj).toString();
            this.objectTable.remove(oidString);
        }
    }

    public void finalize() {
        Logger logger = LoggerFactory.getDefaultLogger();
        logger.info("OJB CACHE STATISTICS");
        logger.info("lookups:   " + this.hitCount);
        logger.info("failures:  " + this.failCount);
        logger.info("reclaimed: " + this.gcCount);
    }
}

