/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.server;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.accesslayer.PkIterator;
import ojb.broker.accesslayer.RsIterator;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.query.Query;
import ojb.broker.server.BetterObjectInputStream;
import ojb.broker.server.BrokerPool;
import ojb.broker.server.PersistenceBrokerClient;
import ojb.broker.server.PersistenceBrokerServer;
import ojb.broker.server.PkEnumerationStub;
import ojb.broker.server.Request;
import ojb.broker.server.RsIteratorStub;
import ojb.broker.server.RsIteratorTable;
import ojb.broker.server.ServerPool;
import ojb.broker.singlevm.PersistenceBrokerImpl;
import ojb.broker.util.Logger;
import ojb.broker.util.LoggerFactory;
import ojb.broker.util.ObjectModification;
import org.odmg.TransactionAbortedException;
import org.odmg.TransactionInProgressException;
import org.odmg.TransactionNotInProgressException;

public class RequestProcessor
implements Runnable {
    private PersistenceBrokerServer server;
    private BrokerPool brokerpool;
    private static RsIteratorTable iterators = new RsIteratorTable();
    private Logger logger;
    private Socket connection = null;
    private Request currentRequest;
    private Object currentResult;

    public synchronized void setSocket(Socket s) {
        this.connection = s;
        this.notify();
    }

    public RequestProcessor(PersistenceBrokerServer srv, BrokerPool pool) {
        this.brokerpool = pool;
        this.server = srv;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    /*
     * Loose catch block
     */
    public synchronized void run() {
        while (true) {
            if (this.connection == null) {
                this.logger.debug(Thread.currentThread().getName() + " waiting...");
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    continue;
                }
            }
            this.logger.debug(Thread.currentThread().getName() + " working...");
            this.dispatch(this.connection);
            Object var3_4 = null;
            try {
                this.connection.close();
                this.connection = null;
                this.server.releaseProcessor(this);
            }
            catch (IOException e) {
                this.connection = null;
                this.server.releaseProcessor(this);
            }
            continue;
            {
                catch (Throwable t) {
                    this.logger.error(this.currentRequest);
                    this.logger.error(this.currentResult);
                    this.logger.error(t);
                    var3_4 = null;
                    try {
                        this.connection.close();
                        this.connection = null;
                        this.server.releaseProcessor(this);
                    }
                    catch (IOException e) {
                        this.connection = null;
                        this.server.releaseProcessor(this);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var3_4 = null;
                try {
                    this.connection.close();
                    this.connection = null;
                    this.server.releaseProcessor(this);
                }
                catch (IOException e) {
                    this.connection = null;
                    this.server.releaseProcessor(this);
                }
                throw throwable;
            }
        }
    }

    private void dispatch(Socket connection) throws IOException, ClassNotFoundException {
        Request request = this.getRequestFromSocket(connection);
        int methodIndex = request.getMethodIndex();
        int brokerId = request.getBrokerId();
        Object arg1 = request.getArg1();
        Object arg2 = request.getArg2();
        this.logger.debug("dispatching [" + methodIndex + ",");
        this.logger.debug(brokerId + ",");
        this.logger.debug(arg1 + ",");
        this.logger.debug(arg2 + "]");
        Object result = null;
        switch (methodIndex) {
            case 2: {
                result = this.beginTransaction(brokerId);
                break;
            }
            case 1: {
                result = this.abortTransaction(brokerId);
                break;
            }
            case 3: {
                result = this.commitTransaction(brokerId);
                break;
            }
            case 4: {
                result = this.delete(brokerId, arg1);
                break;
            }
            case 5: {
                result = this.getCollectionByQueryMC(brokerId, arg1, arg2);
                break;
            }
            case 6: {
                result = this.getCollectionByQuery(brokerId, arg1);
                break;
            }
            case 7: {
                result = this.getIteratorByQuery(brokerId, arg1);
                break;
            }
            case 8: {
                result = this.getObjectByIdentity(brokerId, arg1);
                break;
            }
            case 9: {
                result = this.getObjectByQuery(brokerId, arg1);
                break;
            }
            case 10: {
                result = this.getPkEnumerationByQuery(brokerId, arg1, arg2);
                break;
            }
            case 11: {
                result = this.store(brokerId, arg1);
                break;
            }
            case 12: {
                result = this.storeWithModification(brokerId, arg1, arg2);
                break;
            }
            case 13: {
                result = this.getUniqueId(brokerId, arg1, arg2);
                break;
            }
            case 27: {
                result = this.getUniqueLong(brokerId, arg1, arg2);
                break;
            }
            case 18: {
                result = this.getUniqueString(brokerId, arg1, arg2);
                break;
            }
            case 26: {
                result = this.getUniqueObject(brokerId, arg1, arg2);
                break;
            }
            case 28: {
                result = this.getCount(brokerId, arg1);
                break;
            }
            case 14: {
                result = this.hasNext(arg1);
                break;
            }
            case 15: {
                result = this.next(arg1);
                break;
            }
            case 16: {
                this.releaseDbResources(arg1);
                break;
            }
            case 17: {
                result = this.removeFromCache(brokerId, arg1);
                break;
            }
            case 25: {
                result = this.invalidate(brokerId, arg1);
                break;
            }
            case 21: {
                result = this.clearCache(brokerId);
                break;
            }
            case 19: {
                result = this.getClassDescriptor(brokerId, arg1);
                break;
            }
            case 20: {
                result = this.setClassDescriptor(brokerId, arg1);
                break;
            }
            case 24: {
                result = this.getExtentClass(brokerId, arg1);
                break;
            }
            case 29: {
                result = this.getReportQueryIteratorByQuery(brokerId, arg1);
                break;
            }
            case 9000: {
                result = this.srvPing(connection);
                break;
            }
            default: {
                result = new PersistenceBrokerException("OJB ERROR: Unknown server operation: " + methodIndex);
            }
        }
        this.currentResult = result;
        this.sendResultbackToClient(connection, result);
    }

    private void sendResultbackToClient(Socket socket, Object result) throws IOException {
        try {
            OutputStream outstream = socket.getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(outstream);
            oos.writeObject(result);
            oos.flush();
            outstream.flush();
        }
        catch (IOException e) {
            this.logger.error(e);
            throw e;
        }
    }

    private Request getRequestFromSocket(Socket socket) throws IOException, ClassNotFoundException {
        Request request;
        InputStream is = socket.getInputStream();
        BufferedInputStream bis = new BufferedInputStream(is);
        BetterObjectInputStream ois = new BetterObjectInputStream(bis);
        this.currentRequest = request = (Request)ois.readObject();
        this.currentResult = null;
        return request;
    }

    private Object srvPing(Socket connection) {
        StringBuffer buf = new StringBuffer();
        buf.append("ping ");
        buf.append(connection.getLocalAddress());
        buf.append(" ");
        buf.append(Thread.currentThread().getName());
        String result = buf.toString();
        return result;
    }

    private Object getClassDescriptor(int brokerId, Object arg1) {
        Serializable result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            result = broker.getClassDescriptor((Class)arg1);
            this.brokerpool.releaseBrokerId(brokerId);
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object getExtentClass(int brokerId, Object arg1) {
        Serializable result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            result = broker.getExtentClass((Class)arg1);
            this.brokerpool.releaseBrokerId(brokerId);
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object setClassDescriptor(int brokerId, Object arg1) {
        PersistenceBrokerException result = null;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            broker.setClassDescriptor((ClassDescriptor)arg1);
            this.brokerpool.releaseBrokerId(brokerId);
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object removeFromCache(int brokerId, Object arg1) {
        PersistenceBrokerException result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            broker.removeFromCache(arg1);
            this.brokerpool.releaseBrokerId(brokerId);
            result = null;
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object invalidate(int brokerId, Object arg1) {
        PersistenceBrokerException result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            broker.invalidate((Identity)arg1);
            this.brokerpool.releaseBrokerId(brokerId);
            result = null;
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object clearCache(int brokerId) {
        PersistenceBrokerException result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            broker.clearCache();
            this.brokerpool.releaseBrokerId(brokerId);
            result = null;
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private void releaseDbResources(Object arg1) {
        Integer id = (Integer)arg1;
        iterators.release(id);
    }

    private Object next(Object arg1) {
        Object result;
        Integer id = (Integer)arg1;
        Iterator iter = iterators.getIteratorById(id);
        try {
            result = iter.next();
        }
        catch (NoSuchElementException e) {
            result = e;
            iterators.release(id);
        }
        return result;
    }

    private Object hasNext(Object arg1) {
        Integer id = (Integer)arg1;
        Iterator iter = iterators.getIteratorById(id);
        boolean hasnext = iter.hasNext();
        Boolean result = new Boolean(hasnext);
        if (!hasnext) {
            iterators.release(id);
        }
        return result;
    }

    private Object getUniqueString(int brokerId, Object arg1, Object arg2) {
        Object result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            result = broker.getUniqueString((Class)arg1, (String)arg2);
            this.logger.debug("UID: " + result);
            this.brokerpool.releaseBrokerId(brokerId);
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object getUniqueObject(int brokerId, Object arg1, Object arg2) {
        Object result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            result = broker.getUniqueObject((Class)arg1, (String)arg2);
            this.logger.debug("UID: " + result);
            this.brokerpool.releaseBrokerId(brokerId);
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object getUniqueLong(int brokerId, Object arg1, Object arg2) {
        Serializable result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            result = new Long(broker.getUniqueLong((Class)arg1, (String)arg2));
            this.logger.debug("UID: " + result);
            this.brokerpool.releaseBrokerId(brokerId);
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object getCount(int brokerId, Object arg1) {
        Serializable result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            result = new Integer(broker.getCount((Query)arg1));
            this.brokerpool.releaseBrokerId(brokerId);
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object getUniqueId(int brokerId, Object arg1, Object arg2) {
        Serializable result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            int uid = broker.getUniqueId((Class)arg1, (String)arg2);
            this.logger.debug("UID: " + uid);
            this.brokerpool.releaseBrokerId(brokerId);
            result = new Integer(uid);
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object storeWithModification(int brokerId, Object arg1, Object arg2) {
        PersistenceBrokerException result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            broker.store(arg1, (ObjectModification)arg2);
            ((PersistenceBrokerImpl)broker).checkPoint();
            this.brokerpool.releaseBrokerId(brokerId);
            result = null;
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object store(int brokerId, Object arg1) {
        PersistenceBrokerException result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            broker.store(arg1);
            ((PersistenceBrokerImpl)broker).checkPoint();
            this.brokerpool.releaseBrokerId(brokerId);
            result = null;
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object getPkEnumerationByQuery(int brokerId, Object arg1, Object arg2) {
        Serializable result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            Enumeration enumeration = broker.getPKEnumerationByQuery((Class)arg1, (Query)arg2);
            PkIterator iter = new PkIterator(enumeration);
            Integer iid = iterators.getUniqueId();
            iterators.register(iid, iter);
            ServerPool pool = new ServerPool(PersistenceBrokerFactory.getConfiguration().getServers());
            PersistenceBrokerClient serializableBroker = new PersistenceBrokerClient(pool);
            result = new PkEnumerationStub(serializableBroker, iid);
            this.brokerpool.releaseBrokerId(brokerId);
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object getObjectByQuery(int brokerId, Object arg1) {
        Object result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            result = broker.getObjectByQuery((Query)arg1);
            this.brokerpool.releaseBrokerId(brokerId);
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object getObjectByIdentity(int brokerId, Object arg1) {
        Object result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            result = broker.getObjectByIdentity((Identity)arg1);
            this.brokerpool.releaseBrokerId(brokerId);
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object getIteratorByQuery(int brokerId, Object arg1) {
        Serializable result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            RsIterator rsiter = (RsIterator)broker.getIteratorByQuery((Query)arg1);
            Integer iid = iterators.getUniqueId();
            iterators.register(iid, rsiter);
            ServerPool pool = new ServerPool(PersistenceBrokerFactory.getConfiguration().getServers());
            PersistenceBrokerClient serializableBroker = new PersistenceBrokerClient(pool);
            result = new RsIteratorStub(serializableBroker, iid);
            this.brokerpool.releaseBrokerId(brokerId);
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object getReportQueryIteratorByQuery(int brokerId, Object arg1) {
        Serializable result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            RsIterator rsiter = (RsIterator)broker.getReportQueryIteratorByQuery((Query)arg1);
            Integer iid = iterators.getUniqueId();
            iterators.register(iid, rsiter);
            ServerPool pool = new ServerPool(PersistenceBrokerFactory.getConfiguration().getServers());
            PersistenceBrokerClient serializableBroker = new PersistenceBrokerClient(pool);
            result = new RsIteratorStub(serializableBroker, iid);
            this.brokerpool.releaseBrokerId(brokerId);
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object getCollectionByQuery(int brokerId, Object arg1) {
        Object result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            result = broker.getCollectionByQuery((Query)arg1);
            this.brokerpool.releaseBrokerId(brokerId);
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object getCollectionByQueryMC(int brokerId, Object arg1, Object arg2) {
        Serializable result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            result = broker.getCollectionByQuery((Class)arg1, (Query)arg2);
            this.brokerpool.releaseBrokerId(brokerId);
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object delete(int brokerId, Object arg1) {
        PersistenceBrokerException result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
        }
        PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
        try {
            broker.delete(arg1);
            this.brokerpool.releaseBrokerId(brokerId);
            result = null;
        }
        catch (PersistenceBrokerException e) {
            this.brokerpool.releaseBrokerId(brokerId);
            result = e;
        }
        return result;
    }

    private Object commitTransaction(int brokerId) {
        Serializable result;
        if (brokerId != -1) {
            PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
            try {
                broker.commitTransaction();
                this.brokerpool.releaseBrokerId(brokerId);
                result = new Integer(-1);
            }
            catch (TransactionNotInProgressException e) {
                this.brokerpool.releaseBrokerId(brokerId);
                result = e;
            }
            catch (TransactionAbortedException e) {
                this.brokerpool.releaseBrokerId(brokerId);
                result = e;
            }
        } else {
            result = new TransactionNotInProgressException();
        }
        return result;
    }

    private Object abortTransaction(int brokerId) {
        Serializable result;
        if (brokerId != -1) {
            PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
            try {
                broker.abortTransaction();
                this.brokerpool.releaseBrokerId(brokerId);
                result = new Integer(-1);
            }
            catch (TransactionNotInProgressException e) {
                result = new TransactionNotInProgressException();
            }
        } else {
            result = new TransactionNotInProgressException();
        }
        return result;
    }

    private Object beginTransaction(int brokerId) {
        Serializable result;
        if (brokerId == -1) {
            brokerId = this.brokerpool.getFreeBrokerId();
            result = new Integer(brokerId);
            PersistenceBroker broker = this.brokerpool.getBrokerById(brokerId);
            try {
                broker.beginTransaction();
                this.logger.debug("Broker" + brokerId + " started tx");
            }
            catch (TransactionInProgressException e) {
                this.logger.error("Server told client to take an already used broker");
                this.brokerpool.releaseBrokerId(brokerId);
                result = new TransactionInProgressException();
            }
        } else {
            this.logger.error("Client tries to open tx twice");
            this.brokerpool.releaseBrokerId(brokerId);
            result = new TransactionInProgressException();
        }
        return result;
    }
}

