/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow;

import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRoute;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.workflow.util.WorkflowUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WorkflowRouteMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowRouteMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            ArrayList<Integer> intValues = new ArrayList<Integer>();
            int valuesize = values.size();
            for (int i = 0; i < valuesize; ++i) {
                intValues.add(Integer.valueOf(values.get(i)));
            }
            SelectQuery query = Database.query(EipTWorkflowRoute.class);
            Expression exp1 = ExpressionFactory.inDbExp((String)"ROUTE_ID", intValues);
            query.setQualifier(exp1);
            List routelist = query.fetchList();
            if (routelist == null || routelist.size() == 0) {
                return false;
            }
            for (EipTWorkflowRoute route : routelist) {
                List<EipTWorkflowRequest> requests = WorkflowUtils.getEipTWorkflowRequest(route);
                for (EipTWorkflowRequest request : requests) {
                    request.setEipTWorkflowRoute(null);
                }
                List<EipTWorkflowCategory> categories = WorkflowUtils.getEipTworkflowCategory(route);
                for (EipTWorkflowCategory category : categories) {
                    category.setEipTWorkflowRoute(null);
                }
            }
            Database.deleteAll((List)routelist);
            Database.commit();
            for (EipTWorkflowRoute route : routelist) {
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(route.getRouteId().intValue(), 122, route.getRouteName());
            }
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"workflow", (Throwable)ex);
            return false;
        }
        return true;
    }
}

